/* auto-generated by NAPI-RS */
/* eslint-disable */

export function ageDecryptWithPassphrase(passphrase: string, data: Uint8Array, signal?: AbortSignal | undefined | null): Promise<Buffer>

/** Encryption API */
export function ageEncryptWithPassphrase(passphrase: string, data: Uint8Array, signal?: AbortSignal | undefined | null): Promise<Buffer>

export function cancelAllRequests(): Promise<void>

/** Helper */
export function canonicalizePath(filePath: string): Promise<string>

export function decryptFnames(graphUuid: string, fnames: Array<string>): Array<string>

/**
 * (delete-local-file [this graph-uuid base-path filepath access-token])
 * NOTE: token is not used
 */
export function deleteLocalFiles(graphUuid: string, basePath: string, filePaths: Array<string>): Promise<void>

/** (delete-remote-file [this graph-uuid base-path filepath local-txid access-token]))#[napi] */
export function deleteRemoteFiles(graphUuid: string, basePath: string, filePaths: Array<string>, txid: number, token: string): Promise<number>

export function encryptFnames(graphUuid: string, fnames: Array<string>): Array<string>

export function fetchRemoteFiles(graphUuid: string, basePath: string, filePaths: Array<string>, token: string): Promise<Array<string>>

export interface FileMeta {
  size: number
  /** modified time, in milliseconds */
  mtime: number
  /** creation time, in milliseconds */
  ctime: number
  md5: string
  fname: string
  incomingFname: string
  normalizedFname: string
  encryptedFname: string
}

/** (get-local-all-files-meta [this graph-uuid base-path] "get all local files' metadata") */
export function getLocalAllFilesMeta(graphUuid: string, basePath: string): Promise<Record<string, FileMeta>>

/**
 * get local files' metadata: file-size, md5
 * (get-local-files-meta [this graph-uuid base-path filepaths] "get local files' metadata")
 */
export function getLocalFilesMeta(graphUuid: string, basePath: string, filePaths: Array<string>): Promise<Record<string, FileMeta>>

/** Set rsapi Logger */
export function initLogger(jsLoggingFn: (...args: any[]) => any): void

/** Age encryption key generation */
export function keygen(): Promise<Record<string, string>>

/** Metadata for batch remote update */
export interface Metadata {
  fsCaseSensitive: boolean
  version: string
  revision: string
  platform: string
}

/** Download/Upload Progress Info */
export interface Progress {
  graphUuid: string
  file: string
  type: string
  progress: number
  total: number
  percent: number
}

/** (rename-local-file [this graph-uuid base-path from to access-token]) */
export function renameLocalFile(graphUuid: string, basePath: string, from: string, to: string): Promise<void>

/** Set dev environment along with encryption key */
export function setEnv(graphUuid: string, env: string, secretKey: string, publicKey: string): Promise<void>

export function setProgressCallback(callback: (...args: any[]) => any): void

export function setProxy(proxy?: string | undefined | null): Promise<void>

/**
 * remote -> local
 * (update-local-file [this graph-uuid base-path filepath access-token] "remote -> local")
 */
export function updateLocalFiles(graphUuid: string, basePath: string, filePaths: Array<string>, token: string): Promise<void>

export function updateLocalVersionFiles(graphUuid: string, basePath: string, filePaths: Array<string>, token: string): Promise<void>

export function updateRemoteFiles(graphUuid: string, basePath: string, filePaths: Array<string>, txid: number, token: string, metadata?: Metadata | undefined | null): Promise<number>

