/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.ResourcePacksReloadedEvent;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1146;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public class Names {
    private static final Map<class_1291, String> statusEffectNames = new Reference2ObjectOpenHashMap(16);
    private static final Map<class_1792, String> itemNames = new Reference2ObjectOpenHashMap(128);
    private static final Map<class_2248, String> blockNames = new Reference2ObjectOpenHashMap(128);
    private static final Map<class_1887, String> enchantmentNames = new Reference2ObjectOpenHashMap(16);
    private static final Map<class_1299<?>, String> entityTypeNames = new Reference2ObjectOpenHashMap(64);
    private static final Map<class_2396<?>, String> particleTypesNames = new Reference2ObjectOpenHashMap(64);
    private static final Map<class_2960, String> soundNames = new HashMap<class_2960, String>(64);

    private Names() {
    }

    @PreInit
    public static void init() {
        MeteorClient.EVENT_BUS.subscribe(Names.class);
    }

    @EventHandler
    private static void onResourcePacksReloaded(ResourcePacksReloadedEvent event) {
        statusEffectNames.clear();
        itemNames.clear();
        blockNames.clear();
        enchantmentNames.clear();
        entityTypeNames.clear();
        particleTypesNames.clear();
        soundNames.clear();
    }

    public static String get(class_1291 effect) {
        return statusEffectNames.computeIfAbsent(effect, effect1 -> class_3544.method_15440((String)class_1074.method_4662((String)effect1.method_5567(), (Object[])new Object[0])));
    }

    public static String get(class_1792 item) {
        return itemNames.computeIfAbsent(item, item1 -> class_3544.method_15440((String)class_1074.method_4662((String)item1.method_7876(), (Object[])new Object[0])));
    }

    public static String get(class_2248 block) {
        return blockNames.computeIfAbsent(block, block1 -> class_3544.method_15440((String)class_1074.method_4662((String)block1.method_9539(), (Object[])new Object[0])));
    }

    public static String get(class_1887 enchantment) {
        return enchantmentNames.computeIfAbsent(enchantment, enchantment1 -> class_3544.method_15440((String)class_1074.method_4662((String)enchantment1.method_8184(), (Object[])new Object[0])));
    }

    public static String get(class_1299<?> entityType) {
        return entityTypeNames.computeIfAbsent(entityType, entityType1 -> class_3544.method_15440((String)class_1074.method_4662((String)entityType1.method_5882(), (Object[])new Object[0])));
    }

    public static String get(class_2396<?> type) {
        if (!(type instanceof class_2394)) {
            return "";
        }
        return particleTypesNames.computeIfAbsent(type, effect1 -> StringUtils.capitalize((String)class_7923.field_41180.method_10221((Object)type).method_12832().replace("_", " ")));
    }

    public static String getSoundName(class_2960 id) {
        return soundNames.computeIfAbsent(id, identifier -> {
            class_1146 soundSet = MeteorClient.mc.method_1483().method_4869(identifier);
            if (soundSet == null) {
                return identifier.method_12832();
            }
            class_2561 text = soundSet.method_4886();
            if (text == null) {
                return identifier.method_12832();
            }
            return class_3544.method_15440((String)text.getString());
        });
    }

    public static String get(class_1799 stack) {
        return stack.method_7964().getString();
    }
}

