/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.entity;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.CrossbowItemAccessor;
import meteordevelopment.meteorclient.mixin.ProjectileInGroundAccessor;
import meteordevelopment.meteorclient.mixininterface.IVec3d;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.MissHitResult;
import net.minecraft.class_1297;
import net.minecraft.class_1667;
import net.minecraft.class_1670;
import net.minecraft.class_1674;
import net.minecraft.class_1675;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1687;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4076;
import net.minecraft.class_4537;
import net.minecraft.class_8956;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ProjectileEntitySimulator {
    private static final class_2338.class_2339 blockPos = new class_2338.class_2339();
    private static final class_243 pos3d = new class_243(0.0, 0.0, 0.0);
    private static final class_243 prevPos3d = new class_243(0.0, 0.0, 0.0);
    public final Vector3d pos = new Vector3d();
    private final Vector3d velocity = new Vector3d();
    private double gravity;
    private double airDrag;
    private double waterDrag;

    public boolean set(class_1297 user, class_1799 itemStack, double simulated, boolean accurate, double tickDelta) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1753) {
            double charge = class_1753.method_7722((int)MeteorClient.mc.field_1724.method_6048());
            if (charge <= 0.0) {
                return false;
            }
            this.set(user, 0.0, charge * 3.0, simulated, 0.05f, 0.6, accurate, tickDelta);
        } else if (item instanceof class_1764) {
            if (!class_1764.method_7781((class_1799)itemStack)) {
                return false;
            }
            if (((class_9278)itemStack.method_57824(class_9334.field_49649)).method_57438(class_1802.field_8639)) {
                this.set(user, 0.0, CrossbowItemAccessor.getSpeed((class_9278)itemStack.method_57824(class_9334.field_49649)), simulated, 0.0, 0.6, accurate, tickDelta);
            } else {
                this.set(user, 0.0, CrossbowItemAccessor.getSpeed((class_9278)itemStack.method_57824(class_9334.field_49649)), simulated, 0.05, 0.6, accurate, tickDelta);
            }
        } else if (item instanceof class_1787) {
            this.setFishingBobber(user, tickDelta);
        } else if (item instanceof class_1835) {
            this.set(user, 0.0, 2.5, simulated, 0.05, 0.99, accurate, tickDelta);
        } else if (item instanceof class_1823 || item instanceof class_1771 || item instanceof class_1776) {
            this.set(user, 0.0, 1.5, simulated, 0.03, 0.8, accurate, tickDelta);
        } else if (item instanceof class_1779) {
            this.set(user, -20.0, 0.7, simulated, 0.07, 0.8, accurate, tickDelta);
        } else if (item instanceof class_4537) {
            this.set(user, -20.0, 0.5, simulated, 0.05, 0.8, accurate, tickDelta);
        } else {
            return false;
        }
        return true;
    }

    public void set(class_1297 user, double roll, double speed, double simulated, double gravity, double waterDrag, boolean accurate, double tickDelta) {
        double z;
        double y;
        double x;
        Utils.set(this.pos, user, tickDelta).add(0.0, (double)user.method_18381(user.method_18376()), 0.0);
        double yaw = class_3532.method_16436((double)tickDelta, (double)user.field_5982, (double)user.method_36454());
        double pitch = class_3532.method_16436((double)tickDelta, (double)user.field_6004, (double)user.method_36455());
        if (simulated == 0.0) {
            x = -Math.sin(yaw * 0.017453292) * Math.cos(pitch * 0.017453292);
            y = -Math.sin((pitch + roll) * 0.017453292);
            z = Math.cos(yaw * 0.017453292) * Math.cos(pitch * 0.017453292);
        } else {
            class_243 vec3d = user.method_18864(1.0f);
            Quaterniond quaternion = new Quaterniond().setAngleAxis(simulated, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = user.method_5828(1.0f);
            Vector3d vector3f = new Vector3d(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350);
            vector3f.rotate((Quaterniondc)quaternion);
            x = vector3f.x;
            y = vector3f.y;
            z = vector3f.z;
        }
        this.velocity.set(x, y, z).normalize().mul(speed);
        if (accurate) {
            class_243 vel = user.method_18798();
            this.velocity.add(vel.field_1352, user.method_24828() ? 0.0 : vel.field_1351, vel.field_1350);
        }
        this.gravity = gravity;
        this.airDrag = 0.99;
        this.waterDrag = waterDrag;
    }

    public boolean set(class_1297 entity, boolean accurate) {
        ProjectileInGroundAccessor ppe;
        if (entity instanceof ProjectileInGroundAccessor && (ppe = (ProjectileInGroundAccessor)entity).getInGround()) {
            return false;
        }
        if (entity instanceof class_1667) {
            this.set(entity, 0.05, 0.6, accurate);
        } else if (entity instanceof class_1685) {
            this.set(entity, 0.05, 0.99, accurate);
        } else if (entity instanceof class_1684 || entity instanceof class_1680 || entity instanceof class_1681) {
            this.set(entity, 0.03, 0.8, accurate);
        } else if (entity instanceof class_1683) {
            this.set(entity, 0.07, 0.8, accurate);
        } else if (entity instanceof class_1686) {
            this.set(entity, 0.05, 0.8, accurate);
        } else if (entity instanceof class_1687 || entity instanceof class_1674 || entity instanceof class_1670 || entity instanceof class_8956) {
            this.set(entity, 0.0, 1.0, accurate);
            this.airDrag = 1.0;
        } else {
            return false;
        }
        if (entity.method_5740()) {
            this.gravity = 0.0;
        }
        return true;
    }

    public void set(class_1297 entity, double gravity, double waterDrag, boolean accurate) {
        this.pos.set(entity.method_23317(), entity.method_23318(), entity.method_23321());
        double speed = entity.method_18798().method_1033();
        this.velocity.set(entity.method_18798().field_1352, entity.method_18798().field_1351, entity.method_18798().field_1350).normalize().mul(speed);
        if (accurate) {
            class_243 vel = entity.method_18798();
            this.velocity.add(vel.field_1352, entity.method_24828() ? 0.0 : vel.field_1351, vel.field_1350);
        }
        this.gravity = gravity;
        this.airDrag = 0.99;
        this.waterDrag = waterDrag;
    }

    public void setFishingBobber(class_1297 user, double tickDelta) {
        double yaw = class_3532.method_16436((double)tickDelta, (double)user.field_5982, (double)user.method_36454());
        double pitch = class_3532.method_16436((double)tickDelta, (double)user.field_6004, (double)user.method_36455());
        double h = Math.cos(-yaw * 0.01745329238474369 - 3.1415927410125732);
        double i = Math.sin(-yaw * 0.01745329238474369 - 3.1415927410125732);
        double j = -Math.cos(-pitch * 0.01745329238474369);
        double k = Math.sin(-pitch * 0.01745329238474369);
        Utils.set(this.pos, user, tickDelta).sub(i * 0.3, 0.0, h * 0.3).add(0.0, (double)user.method_18381(user.method_18376()), 0.0);
        this.velocity.set(-i, class_3532.method_15350((double)(-(k / j)), (double)-5.0, (double)5.0), -h);
        double l = this.velocity.length();
        this.velocity.mul(0.6 / l + 0.5, 0.6 / l + 0.5, 0.6 / l + 0.5);
        this.gravity = 0.03;
        this.airDrag = 0.92;
        this.waterDrag = 0.0;
    }

    public class_239 tick() {
        ((IVec3d)prevPos3d).set(this.pos);
        this.pos.add((Vector3dc)this.velocity);
        this.velocity.mul(this.isTouchingWater() ? this.waterDrag : this.airDrag);
        this.velocity.sub(0.0, this.gravity, 0.0);
        if (this.pos.y < (double)MeteorClient.mc.field_1687.method_31607()) {
            return MissHitResult.INSTANCE;
        }
        int chunkX = class_4076.method_32204((double)this.pos.x);
        int chunkZ = class_4076.method_32204((double)this.pos.z);
        if (!MeteorClient.mc.field_1687.method_2935().method_12123(chunkX, chunkZ)) {
            return MissHitResult.INSTANCE;
        }
        ((IVec3d)pos3d).set(this.pos);
        if (pos3d.equals((Object)prevPos3d)) {
            return MissHitResult.INSTANCE;
        }
        class_239 hitResult = this.getCollision();
        return hitResult.method_17783() == class_239.class_240.field_1333 ? null : hitResult;
    }

    private boolean isTouchingWater() {
        blockPos.method_10102(this.pos.x, this.pos.y, this.pos.z);
        class_3610 fluidState = MeteorClient.mc.field_1687.method_8316((class_2338)blockPos);
        if (fluidState.method_15772() != class_3612.field_15910 && fluidState.method_15772() != class_3612.field_15909) {
            return false;
        }
        return this.pos.y - (double)((int)this.pos.y) <= (double)fluidState.method_20785();
    }

    private class_239 getCollision() {
        class_3966 hitResult2;
        class_243 vec3d3 = prevPos3d;
        class_3965 hitResult = MeteorClient.mc.field_1687.method_17742(new class_3959(vec3d3, pos3d, class_3959.class_3960.field_17558, this.waterDrag == 0.0 ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)MeteorClient.mc.field_1724));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            vec3d3 = hitResult.method_17784();
        }
        if ((hitResult2 = class_1675.method_18077((class_1937)MeteorClient.mc.field_1687, (class_1297)MeteorClient.mc.field_1724, (class_243)vec3d3, (class_243)pos3d, (class_238)new class_238(this.pos.x, this.pos.y, this.pos.z, this.pos.x, this.pos.y, this.pos.z).method_18804(MeteorClient.mc.field_1724.method_18798()).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805() && entity.method_5863())) != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }
}

