/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.waypoints;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.waypoints.Waypoint;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.files.StreamUtils;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.world.Dimension;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class Waypoints
extends System<Waypoints>
implements Iterable<Waypoint> {
    public static final String[] BUILTIN_ICONS = new String[]{"square", "circle", "triangle", "star", "diamond", "skull"};
    public final Map<String, class_1044> icons = new ConcurrentHashMap<String, class_1044>();
    public final Map<String, Waypoint> waypoints = new ConcurrentHashMap<String, Waypoint>();

    public Waypoints() {
        super(null);
    }

    public static Waypoints get() {
        return Systems.get(Waypoints.class);
    }

    @Override
    public void init() {
        File iconsFolder = new File(new File(MeteorClient.FOLDER, "waypoints"), "icons");
        iconsFolder.mkdirs();
        for (String builtinIcon : BUILTIN_ICONS) {
            File iconFile = new File(iconsFolder, builtinIcon + ".png");
            if (iconFile.exists()) continue;
            this.copyIcon(iconFile);
        }
        File[] files = iconsFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".png")) continue;
            try {
                String name = file.getName().replace(".png", "");
                class_1043 texture = new class_1043(class_1011.method_4309((InputStream)new FileInputStream(file)));
                this.icons.put(name, (class_1044)texture);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean add(Waypoint waypoint) {
        Waypoint added = this.waypoints.put(waypoint.name.get().toLowerCase(Locale.ROOT), waypoint);
        if (added != null) {
            this.save();
        }
        return added != null;
    }

    public boolean remove(Waypoint waypoint) {
        Waypoint removed = this.waypoints.remove(waypoint.name.get().toLowerCase(Locale.ROOT));
        if (removed != null) {
            this.save();
        }
        return removed != null;
    }

    public Waypoint get(String name) {
        return this.waypoints.get(name.toLowerCase(Locale.ROOT));
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.load();
    }

    @EventHandler(priority=-200)
    private void onGameDisconnected(GameLeftEvent event) {
        this.waypoints.clear();
    }

    public static boolean checkDimension(Waypoint waypoint) {
        Dimension waypointDim;
        Dimension playerDim = PlayerUtils.getDimension();
        if (playerDim == (waypointDim = waypoint.dimension.get())) {
            return true;
        }
        if (!waypoint.opposite.get().booleanValue()) {
            return false;
        }
        boolean playerOpp = playerDim == Dimension.Overworld || playerDim == Dimension.Nether;
        boolean waypointOpp = waypointDim == Dimension.Overworld || waypointDim == Dimension.Nether;
        return playerOpp && waypointOpp;
    }

    @Override
    public File getFile() {
        if (!Utils.canUpdate()) {
            return null;
        }
        return new File(new File(MeteorClient.FOLDER, "waypoints"), Utils.getFileWorldName() + ".nbt");
    }

    public boolean isEmpty() {
        return this.waypoints.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Waypoint> iterator() {
        return this.waypoints.values().iterator();
    }

    public ListIterator<Waypoint> iteratorReverse() {
        return new ArrayList<Waypoint>(this.waypoints.values()).listIterator(this.waypoints.size());
    }

    private void copyIcon(File file) {
        StreamUtils.copy(Waypoints.class.getResourceAsStream("/assets/meteor-client/textures/icons/waypoints/" + file.getName()), file);
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10566("waypoints", (class_2520)NbtUtils.listToTag(this.waypoints.values()));
        return tag;
    }

    @Override
    public Waypoints fromTag(class_2487 tag) {
        Map<String, Waypoint> fromNbt = NbtUtils.listFromTag(tag.method_10554("waypoints", 10), Waypoint::new).stream().collect(Collectors.toMap(o -> o.name.get().toLowerCase(Locale.ROOT), o -> o));
        this.waypoints.clear();
        this.waypoints.putAll(fromNbt);
        return this;
    }
}

