/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.world;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.world.BlockIterator;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class LiquidFiller
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWhitelist;
    private final Setting<PlaceIn> placeInLiquids;
    private final Setting<Shape> shape;
    private final Setting<Double> range;
    private final Setting<Integer> delay;
    private final Setting<Integer> maxBlocksPerTick;
    private final Setting<SortMode> sortMode;
    private final Setting<Boolean> rotate;
    private final Setting<ListMode> listMode;
    private final Setting<List<class_2248>> whitelist;
    private final Setting<List<class_2248>> blacklist;
    private final List<class_2338.class_2339> blocks;
    private int timer;

    public LiquidFiller() {
        super(Categories.World, "liquid-filler", "Places blocks inside of liquid source blocks within range of you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWhitelist = this.settings.createGroup("Whitelist");
        this.placeInLiquids = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("place-in")).description("What type of liquids to place in.")).defaultValue(PlaceIn.Both)).build());
        this.shape = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape")).description("The shape of placing algorithm.")).defaultValue(Shape.Sphere)).build());
        this.range = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("The place range.")).defaultValue(4.0).min(0.0).build());
        this.delay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay between actions in ticks.")).defaultValue(0)).min(0).build());
        this.maxBlocksPerTick = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-blocks-per-tick")).description("Maximum blocks to try to place per tick.")).defaultValue(1)).min(1).sliderRange(1, 10).build());
        this.sortMode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("sort-mode")).description("The blocks you want to place first.")).defaultValue(SortMode.Closest)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Automatically rotates towards the space targeted for filling.")).defaultValue(true)).build());
        this.listMode = this.sgWhitelist.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("list-mode")).description("Selection mode.")).defaultValue(ListMode.Whitelist)).build());
        this.whitelist = this.sgWhitelist.add(((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("whitelist")).description("The allowed blocks that it will use to fill up the liquid.")).defaultValue(class_2246.field_10566, class_2246.field_10445, class_2246.field_10340, class_2246.field_10515, class_2246.field_10508, class_2246.field_10474, class_2246.field_10115).visible(() -> this.listMode.get() == ListMode.Whitelist)).build());
        this.blacklist = this.sgWhitelist.add(((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blacklist")).description("The denied blocks that it not will use to fill up the liquid.")).visible(() -> this.listMode.get() == ListMode.Blacklist)).build());
        this.blocks = new ArrayList<class_2338.class_2339>();
    }

    @Override
    public void onActivate() {
        this.timer = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        FindItemResult item;
        if (this.timer < this.delay.get()) {
            ++this.timer;
            return;
        }
        this.timer = 0;
        double pX = this.mc.field_1724.method_23317();
        double pY = this.mc.field_1724.method_23318();
        double pZ = this.mc.field_1724.method_23321();
        double rangeSq = Math.pow(this.range.get(), 2.0);
        if (this.shape.get() == Shape.UniformCube) {
            this.range.set(Double.valueOf(Math.round(this.range.get())));
        }
        if (!(item = this.listMode.get() == ListMode.Whitelist ? InvUtils.findInHotbar(itemStack -> itemStack.method_7909() instanceof class_1747 && this.whitelist.get().contains(class_2248.method_9503((class_1792)itemStack.method_7909()))) : InvUtils.findInHotbar(itemStack -> itemStack.method_7909() instanceof class_1747 && !this.blacklist.get().contains(class_2248.method_9503((class_1792)itemStack.method_7909())))).found()) {
            return;
        }
        BlockIterator.register((int)Math.ceil(this.range.get() + 1.0), (int)Math.ceil(this.range.get()), (blockPos, blockState) -> {
            boolean toofarUniformCube;
            boolean toofarSphere = Utils.squaredDistance(pX, pY, pZ, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5) > rangeSq;
            boolean bl = toofarUniformCube = LiquidFiller.maxDist(Math.floor(pX), Math.floor(pY), Math.floor(pZ), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) >= this.range.get();
            if (toofarSphere && this.shape.get() == Shape.Sphere || toofarUniformCube && this.shape.get() == Shape.UniformCube) {
                return;
            }
            class_3611 fluid = blockState.method_26227().method_15772();
            if (this.placeInLiquids.get() == PlaceIn.Both && fluid != class_3612.field_15910 && fluid != class_3612.field_15908 || this.placeInLiquids.get() == PlaceIn.Water && fluid != class_3612.field_15910 || this.placeInLiquids.get() == PlaceIn.Lava && fluid != class_3612.field_15908) {
                return;
            }
            if (!BlockUtils.canPlace(blockPos)) {
                return;
            }
            this.blocks.add(blockPos.method_25503());
        });
        BlockIterator.after(() -> {
            if (this.sortMode.get() == SortMode.TopDown || this.sortMode.get() == SortMode.BottomUp) {
                this.blocks.sort(Comparator.comparingDouble(value -> value.method_10264() * (this.sortMode.get() == SortMode.BottomUp ? 1 : -1)));
            } else if (this.sortMode.get() != SortMode.None) {
                this.blocks.sort(Comparator.comparingDouble(value -> Utils.squaredDistance(pX, pY, pZ, (double)value.method_10263() + 0.5, (double)value.method_10264() + 0.5, (double)value.method_10260() + 0.5) * (double)(this.sortMode.get() == SortMode.Closest ? 1 : -1)));
            }
            int count = 0;
            for (class_2338 class_23382 : this.blocks) {
                if (count >= this.maxBlocksPerTick.get()) break;
                BlockUtils.place(class_23382, item, this.rotate.get(), 0, true);
                ++count;
            }
            this.blocks.clear();
        });
    }

    private static double maxDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = Math.ceil(Math.abs(x2 - x1));
        double dY = Math.ceil(Math.abs(y2 - y1));
        double dZ = Math.ceil(Math.abs(z2 - z1));
        return Math.max(Math.max(dX, dY), dZ);
    }

    public static enum PlaceIn {
        Both,
        Water,
        Lava;

    }

    public static enum Shape {
        Sphere,
        UniformCube;

    }

    public static enum SortMode {
        None,
        Closest,
        Furthest,
        TopDown,
        BottomUp;

    }

    public static enum ListMode {
        Whitelist,
        Blacklist;

    }
}

