/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataOutput;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.game.ItemStackTooltipEvent;
import meteordevelopment.meteorclient.events.render.TooltipDataEvent;
import meteordevelopment.meteorclient.mixin.EntityAccessor;
import meteordevelopment.meteorclient.mixin.EntityBucketItemAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.ByteCountDataOutput;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.player.EChestMemory;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.tooltip.BannerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.BookTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.ContainerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.EntityTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.MapTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.TextTooltipComponent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1745;
import net.minecraft.class_1746;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5761;
import net.minecraft.class_7225;
import net.minecraft.class_9209;
import net.minecraft.class_9262;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9298;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9307;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class BetterTooltips
extends Module {
    public static final Color ECHEST_COLOR = new Color(0, 50, 50);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPreviews;
    private final SettingGroup sgOther;
    private final SettingGroup sgHideFlags;
    private final Setting<DisplayWhen> displayWhen;
    private final Setting<Keybind> keybind;
    private final Setting<Boolean> middleClickOpen;
    private final Setting<Boolean> shulkers;
    private final Setting<Boolean> shulkerCompactTooltip;
    public final Setting<Boolean> echest;
    private final Setting<Boolean> maps;
    public final Setting<Double> mapsScale;
    private final Setting<Boolean> books;
    private final Setting<Boolean> banners;
    private final Setting<Boolean> entitiesInBuckets;
    public final Setting<Boolean> byteSize;
    private final Setting<Boolean> statusEffects;
    private final Setting<Boolean> beehive;
    public final Setting<Boolean> tooltip;
    public final Setting<Boolean> enchantments;
    public final Setting<Boolean> modifiers;
    public final Setting<Boolean> unbreakable;
    public final Setting<Boolean> canDestroy;
    public final Setting<Boolean> canPlaceOn;
    public final Setting<Boolean> additional;
    public final Setting<Boolean> dye;
    public final Setting<Boolean> upgrades;

    public BetterTooltips() {
        super(Categories.Render, "better-tooltips", "Displays more useful tooltips for certain items.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPreviews = this.settings.createGroup("Previews");
        this.sgOther = this.settings.createGroup("Other");
        this.sgHideFlags = this.settings.createGroup("Hide Flags");
        this.displayWhen = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("display-when")).description("When to display previews.")).defaultValue(DisplayWhen.Keybind)).build());
        this.keybind = this.sgGeneral.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("keybind")).description("The bind for keybind mode.")).defaultValue(Keybind.fromKey(342))).visible(() -> this.displayWhen.get() == DisplayWhen.Keybind)).build());
        this.middleClickOpen = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("middle-click-open")).description("Opens a GUI window with the inventory of the storage block or book when you middle click the item.")).defaultValue(true)).build());
        this.shulkers = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("containers")).description("Shows a preview of a containers when hovering over it in an inventory.")).defaultValue(true)).build());
        this.shulkerCompactTooltip = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("compact-shulker-tooltip")).description("Compacts the lines of the shulker tooltip.")).defaultValue(true)).visible(this.shulkers::get)).build());
        this.echest = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("echests")).description("Shows a preview of your echest when hovering over it in an inventory.")).defaultValue(true)).build());
        this.maps = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("maps")).description("Shows a preview of a map when hovering over it in an inventory.")).defaultValue(true)).build());
        this.mapsScale = this.sgPreviews.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("map-scale")).description("The scale of the map preview.")).defaultValue(1.0).min(0.001).sliderMax(1.0).visible(this.maps::get)).build());
        this.books = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("books")).description("Shows contents of a book when hovering over it in an inventory.")).defaultValue(true)).build());
        this.banners = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("banners")).description("Shows banners' patterns when hovering over it in an inventory. Also works with shields.")).defaultValue(true)).build());
        this.entitiesInBuckets = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("entities-in-buckets")).description("Shows entities in buckets when hovering over it in an inventory.")).defaultValue(true)).build());
        this.byteSize = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("byte-size")).description("Displays an item's size in bytes in the tooltip.")).defaultValue(true)).build());
        this.statusEffects = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("status-effects")).description("Adds list of status effects to tooltips of food items.")).defaultValue(true)).build());
        this.beehive = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("beehive")).description("Displays information about a beehive or bee nest.")).defaultValue(true)).build());
        this.tooltip = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tooltip")).description("Show the tooltip when it's hidden.")).defaultValue(false)).build());
        this.enchantments = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enchantments")).description("Show enchantments when it's hidden.")).defaultValue(false)).build());
        this.modifiers = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("modifiers")).description("Show item modifiers when it's hidden.")).defaultValue(false)).build());
        this.unbreakable = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("unbreakable")).description("Show \"Unbreakable\" tag when it's hidden.")).defaultValue(false)).build());
        this.canDestroy = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-destroy")).description("Show \"CanDestroy\" tag when it's hidden.")).defaultValue(false)).build());
        this.canPlaceOn = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-place-on")).description("Show \"CanPlaceOn\" tag when it's hidden.")).defaultValue(false)).build());
        this.additional = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("additional")).description("Show potion effects, firework status, book author, etc when it's hidden.")).defaultValue(false)).build());
        this.dye = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dye")).description("Show dyed item tags when it's hidden.")).defaultValue(false)).build());
        this.upgrades = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("armor-trim")).description("Show armor trims when it's hidden.")).defaultValue(false)).build());
    }

    @EventHandler
    private void appendTooltip(ItemStackTooltipEvent event) {
        if (this.statusEffects.get().booleanValue()) {
            if (event.itemStack.method_7909() == class_1802.field_8766) {
                class_9298 stewEffectsComponent = (class_9298)event.itemStack.method_57824(class_9334.field_49652);
                if (stewEffectsComponent != null) {
                    for (class_9298.class_8751 effectTag : stewEffectsComponent.comp_2416()) {
                        class_1293 effect = new class_1293(effectTag.comp_1838(), effectTag.comp_1839(), 0);
                        event.list.add(1, (class_2561)this.getStatusText(effect));
                    }
                }
            } else {
                class_4174 food = (class_4174)event.itemStack.method_57824(class_9334.field_50075);
                if (food != null) {
                    food.comp_2495().forEach(e -> event.list.add(1, (class_2561)this.getStatusText(e.comp_2496())));
                }
            }
        }
        if (this.beehive.get().booleanValue() && (event.itemStack.method_7909() == class_1802.field_20416 || event.itemStack.method_7909() == class_1802.field_20415)) {
            class_9279 nbtComponent;
            class_9323 components = event.itemStack.method_57353();
            class_9275 blockStateComponent = (class_9275)components.method_57829(class_9334.field_49623);
            if (blockStateComponent != null) {
                String level = (String)blockStateComponent.comp_2381().get("honey_level");
                event.list.add(1, (class_2561)class_2561.method_43470((String)String.format("%sHoney level: %s%s%s.", class_124.field_1080, class_124.field_1054, level, class_124.field_1080)));
            }
            if ((nbtComponent = (class_9279)components.method_57829(class_9334.field_49611)) != null) {
                class_2499 beesTag = nbtComponent.method_57461().method_10554("Bees", 10);
                event.list.add(1, (class_2561)class_2561.method_43470((String)String.format("%sBees: %s%d%s.", class_124.field_1080, class_124.field_1054, beesTag.size(), class_124.field_1080)));
            }
        }
        if (this.byteSize.get().booleanValue()) {
            try {
                event.itemStack.method_57358((class_7225.class_7874)this.mc.field_1724.method_56673()).method_10713((DataOutput)ByteCountDataOutput.INSTANCE);
                int byteCount = ByteCountDataOutput.INSTANCE.getCount();
                ByteCountDataOutput.INSTANCE.reset();
                String count = byteCount >= 1024 ? String.format("%.2f kb", Float.valueOf((float)byteCount / 1024.0f)) : String.format("%d bytes", byteCount);
                event.list.add((class_2561)class_2561.method_43470((String)count).method_27692(class_124.field_1080));
            }
            catch (Exception e2) {
                event.list.add((class_2561)class_2561.method_43470((String)"Error getting bytes.").method_27692(class_124.field_1061));
            }
        }
        if (this.shulkers.get() != false && !this.previewShulkers() && Utils.hasItems(event.itemStack) || event.itemStack.method_7909() == class_1802.field_8466 && this.echest.get() != false && !this.previewEChest() || event.itemStack.method_7909() == class_1802.field_8204 && this.maps.get() != false && !this.previewMaps() || event.itemStack.method_7909() == class_1802.field_8674 && this.books.get() != false && !this.previewBooks() || event.itemStack.method_7909() == class_1802.field_8360 && this.books.get() != false && !this.previewBooks() || event.itemStack.method_7909() instanceof class_1785 && this.entitiesInBuckets.get() != false && !this.previewEntities() || event.itemStack.method_7909() instanceof class_1746 && this.banners.get() != false && !this.previewBanners() || event.itemStack.method_7909() instanceof class_1745 && this.banners.get() != false && !this.previewBanners() || event.itemStack.method_7909() == class_1802.field_8255 && this.banners.get().booleanValue() && !this.previewBanners()) {
            event.list.add((class_2561)class_2561.method_43470((String)""));
            event.list.add((class_2561)class_2561.method_43470((String)("Hold " + String.valueOf(class_124.field_1054) + String.valueOf(this.keybind) + String.valueOf(class_124.field_1070) + " to preview")));
        }
    }

    @EventHandler
    private void getTooltipData(TooltipDataEvent event) {
        if (this.previewShulkers() && Utils.hasItems(event.itemStack)) {
            class_1799[] itemStacks = new class_1799[27];
            Utils.getItemsInContainerItem(event.itemStack, itemStacks);
            event.tooltipData = new ContainerTooltipComponent(itemStacks, Utils.getShulkerColor(event.itemStack));
        } else if (event.itemStack.method_7909() == class_1802.field_8466 && this.previewEChest()) {
            event.tooltipData = EChestMemory.isKnown() ? new ContainerTooltipComponent((class_1799[])EChestMemory.ITEMS.toArray((Object[])new class_1799[27]), ECHEST_COLOR) : new TextTooltipComponent((class_2561)class_2561.method_43470((String)"Unknown ender chest inventory.").method_27692(class_124.field_1079));
        } else if (event.itemStack.method_7909() == class_1802.field_8204 && this.previewMaps()) {
            class_9209 mapIdComponent = (class_9209)event.itemStack.method_57824(class_9334.field_49646);
            if (mapIdComponent != null) {
                event.tooltipData = new MapTooltipComponent(mapIdComponent.comp_2315());
            }
        } else if ((event.itemStack.method_7909() == class_1802.field_8674 || event.itemStack.method_7909() == class_1802.field_8360) && this.previewBooks()) {
            class_2561 page = this.getFirstPage(event.itemStack);
            if (page != null) {
                event.tooltipData = new BookTooltipComponent(page);
            }
        } else if (event.itemStack.method_7909() instanceof class_1746 && this.previewBanners()) {
            event.tooltipData = new BannerTooltipComponent(event.itemStack);
        } else if (event.itemStack.method_7909() instanceof class_1745 && this.previewBanners()) {
            class_9307 bannerPatternsComponent = (class_9307)event.itemStack.method_57824(class_9334.field_49619);
            if (bannerPatternsComponent != null) {
                event.tooltipData = new BannerTooltipComponent(this.createBannerFromLayers(bannerPatternsComponent.comp_2428()));
            }
        } else if (event.itemStack.method_7909() == class_1802.field_8255 && this.previewBanners()) {
            class_1799 banner = this.createBannerFromShield(event.itemStack);
            if (banner != null) {
                event.tooltipData = new BannerTooltipComponent(banner);
            }
        } else {
            class_1792 banner = event.itemStack.method_7909();
            if (banner instanceof class_1785) {
                class_1299<?> type;
                class_1297 entity;
                class_1785 bucketItem = (class_1785)banner;
                if (this.previewEntities() && (entity = (type = ((EntityBucketItemAccessor)bucketItem).getEntityType()).method_5883((class_1937)this.mc.field_1687)) != null) {
                    ((class_5761)entity).method_35170(((class_9279)event.itemStack.method_57824(class_9334.field_49610)).method_57461());
                    ((EntityAccessor)entity).setInWater(true);
                    event.tooltipData = new EntityTooltipComponent(entity);
                }
            }
        }
    }

    public void applyCompactShulkerTooltip(class_1799 shulkerItem, List<class_2561> tooltip) {
        class_9279 nbtComponent = (class_9279)shulkerItem.method_57824(class_9334.field_49611);
        if (nbtComponent != null) {
            if (nbtComponent.method_57450("LootTable")) {
                tooltip.add((class_2561)class_2561.method_43470((String)"???????"));
            }
            if (nbtComponent.method_57450("Items")) {
                class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)nbtComponent.method_57461(), (class_2371)items, (class_7225.class_7874)class_5455.field_40585);
                Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
                for (class_1799 item : items) {
                    if (item.method_7960()) continue;
                    int count = counts.getInt((Object)item.method_7909());
                    counts.put((Object)item.method_7909(), count + item.method_7947());
                }
                counts.keySet().stream().sorted(Comparator.comparingInt(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$2((Object2IntMap)counts, arg_0))).limit(5L).forEach(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$3((Object2IntMap)counts, tooltip, arg_0));
                if (counts.size() > 5) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{counts.size() - 5}).method_27692(class_124.field_1056));
                }
            }
        }
    }

    private class_5250 getStatusText(class_1293 effect) {
        class_5250 text = class_2561.method_43471((String)effect.method_5586());
        if (effect.method_5578() != 0) {
            text.method_27693(String.format(" %d (%s)", effect.method_5578() + 1, class_1292.method_5577((class_1293)effect, (float)1.0f, (float)this.mc.field_1687.method_54719().method_54748()).getString()));
        } else {
            text.method_27693(String.format(" (%s)", class_1292.method_5577((class_1293)effect, (float)1.0f, (float)this.mc.field_1687.method_54719().method_54748()).getString()));
        }
        if (((class_1291)effect.method_5579().comp_349()).method_5573()) {
            return text.method_27692(class_124.field_1078);
        }
        return text.method_27692(class_124.field_1061);
    }

    private class_2561 getFirstPage(class_1799 bookItem) {
        if (bookItem.method_57824(class_9334.field_49653) != null) {
            List pages = ((class_9301)bookItem.method_57824(class_9334.field_49653)).comp_2422();
            if (pages.isEmpty()) {
                return null;
            }
            return class_2561.method_43470((String)((String)((class_9262)pages.getFirst()).method_57140(false)));
        }
        if (bookItem.method_57824(class_9334.field_49606) != null) {
            List pages = ((class_9302)bookItem.method_57824(class_9334.field_49606)).comp_2422();
            if (pages.isEmpty()) {
                return null;
            }
            return (class_2561)((class_9262)pages.getFirst()).method_57140(false);
        }
        return null;
    }

    private class_1799 createBannerFromLayers(List<class_9307.class_9308> pattern) {
        class_1799 bannerItem = new class_1799((class_1935)class_1802.field_8617);
        class_9307 bannerPatterns = (class_9307)bannerItem.method_57824(class_9334.field_49619);
        bannerPatterns.comp_2428().addAll(pattern);
        bannerItem.method_57379(class_9334.field_49619, (Object)bannerPatterns);
        return bannerItem;
    }

    private class_1799 createBannerFromShield(class_1799 shieldItem) {
        if (!shieldItem.method_57353().method_57837() || shieldItem.method_57824(class_9334.field_49611) == null || shieldItem.method_57824(class_9334.field_49620) == null) {
            return null;
        }
        class_1799 bannerItem = new class_1799((class_1935)class_1802.field_8617);
        class_9307 bannerPatternsComponent = (class_9307)bannerItem.method_57824(class_9334.field_49619);
        class_9307 shieldPatternsComponent = (class_9307)shieldItem.method_57824(class_9334.field_49619);
        if (shieldPatternsComponent == null) {
            return bannerItem;
        }
        bannerPatternsComponent.comp_2428().addAll(shieldPatternsComponent.comp_2428());
        return bannerItem;
    }

    public boolean middleClickOpen() {
        return this.isActive() && this.middleClickOpen.get() != false;
    }

    public boolean previewShulkers() {
        return this.isActive() && this.isPressed() && this.shulkers.get() != false;
    }

    public boolean shulkerCompactTooltip() {
        return this.isActive() && this.shulkerCompactTooltip.get() != false;
    }

    private boolean previewEChest() {
        return this.isPressed() && this.echest.get() != false;
    }

    private boolean previewMaps() {
        return this.isPressed() && this.maps.get() != false;
    }

    private boolean previewBooks() {
        return this.isPressed() && this.books.get() != false;
    }

    private boolean previewBanners() {
        return this.isPressed() && this.banners.get() != false;
    }

    private boolean previewEntities() {
        return this.isPressed() && this.entitiesInBuckets.get() != false;
    }

    private boolean isPressed() {
        return this.keybind.get().isPressed() && this.displayWhen.get() == DisplayWhen.Keybind || this.displayWhen.get() == DisplayWhen.Always;
    }

    private static /* synthetic */ void lambda$applyCompactShulkerTooltip$3(Object2IntMap counts, List tooltip, class_1792 item) {
        class_5250 mutableText = item.method_7848().method_27662();
        mutableText.method_10852((class_2561)class_2561.method_43470((String)" x").method_27693(String.valueOf(counts.getInt((Object)item))).method_27692(class_124.field_1080));
        tooltip.add(mutableText);
    }

    private static /* synthetic */ int lambda$applyCompactShulkerTooltip$2(Object2IntMap counts, class_1792 value) {
        return -counts.getInt((Object)value);
    }

    public static enum DisplayWhen {
        Keybind,
        Always;

    }
}

