/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import meteordevelopment.meteorclient.events.entity.EntityAddedEvent;
import meteordevelopment.meteorclient.events.entity.EntityRemovedEvent;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EntityTypeListSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2663;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class Notifier
extends Module {
    private final SettingGroup sgTotemPops;
    private final SettingGroup sgVisualRange;
    private final SettingGroup sgPearl;
    private final Setting<Boolean> totemPops;
    private final Setting<Boolean> totemsIgnoreOwn;
    private final Setting<Boolean> totemsIgnoreFriends;
    private final Setting<Boolean> totemsIgnoreOthers;
    private final Setting<Boolean> visualRange;
    private final Setting<Event> event;
    private final Setting<Set<class_1299<?>>> entities;
    private final Setting<Boolean> visualRangeIgnoreFriends;
    private final Setting<Boolean> visualRangeIgnoreFakes;
    private final Setting<Boolean> visualMakeSound;
    private final Setting<Boolean> pearl;
    private final Setting<Boolean> pearlIgnoreOwn;
    private final Setting<Boolean> pearlIgnoreFriends;
    private final Object2IntMap<UUID> totemPopMap;
    private final Object2IntMap<UUID> chatIdMap;
    private final Map<Integer, class_243> pearlStartPosMap;
    private final Random random;

    public Notifier() {
        super(Categories.Misc, "notifier", "Notifies you of different events.");
        this.sgTotemPops = this.settings.createGroup("Totem Pops");
        this.sgVisualRange = this.settings.createGroup("Visual Range");
        this.sgPearl = this.settings.createGroup("Pearl");
        this.totemPops = this.sgTotemPops.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("totem-pops")).description("Notifies you when a player pops a totem.")).defaultValue(true)).build());
        this.totemsIgnoreOwn = this.sgTotemPops.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-own")).description("Ignores your own totem pops.")).defaultValue(false)).build());
        this.totemsIgnoreFriends = this.sgTotemPops.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-friends")).description("Ignores friends totem pops.")).defaultValue(false)).build());
        this.totemsIgnoreOthers = this.sgTotemPops.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-others")).description("Ignores other players totem pops.")).defaultValue(false)).build());
        this.visualRange = this.sgVisualRange.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("visual-range")).description("Notifies you when an entity enters your render distance.")).defaultValue(false)).build());
        this.event = this.sgVisualRange.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("event")).description("When to log the entities.")).defaultValue(Event.Both)).build());
        this.entities = this.sgVisualRange.add(((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("entities")).description("Which entities to notify about.")).defaultValue(class_1299.field_6097).build());
        this.visualRangeIgnoreFriends = this.sgVisualRange.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-friends")).description("Ignores friends.")).defaultValue(true)).build());
        this.visualRangeIgnoreFakes = this.sgVisualRange.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-fake-players")).description("Ignores fake players.")).defaultValue(true)).build());
        this.visualMakeSound = this.sgVisualRange.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound")).description("Emits a sound effect on enter / leave")).defaultValue(true)).build());
        this.pearl = this.sgPearl.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pearl")).description("Notifies you when a player is teleported using an ender pearl.")).defaultValue(true)).build());
        this.pearlIgnoreOwn = this.sgPearl.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-own")).description("Ignores your own pearls.")).defaultValue(false)).build());
        this.pearlIgnoreFriends = this.sgPearl.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-friends")).description("Ignores friends pearls.")).defaultValue(false)).build());
        this.totemPopMap = new Object2IntOpenHashMap();
        this.chatIdMap = new Object2IntOpenHashMap();
        this.pearlStartPosMap = new HashMap<Integer, class_243>();
        this.random = new Random();
    }

    @EventHandler
    private void onEntityAdded(EntityAddedEvent event) {
        class_1297 class_12972;
        if (!event.entity.method_5667().equals(this.mc.field_1724.method_5667()) && this.entities.get().contains(event.entity.method_5864()) && this.visualRange.get().booleanValue() && this.event.get() != Event.Despawn) {
            if (event.entity instanceof class_1657) {
                if (!(this.visualRangeIgnoreFriends.get().booleanValue() && Friends.get().isFriend((class_1657)event.entity) || this.visualRangeIgnoreFakes.get().booleanValue() && event.entity instanceof FakePlayerEntity)) {
                    ChatUtils.sendMsg(event.entity.method_5628() + 100, class_124.field_1080, "(highlight)%s(default) has entered your visual range!", event.entity.method_5477().getString());
                    if (this.visualMakeSound.get().booleanValue()) {
                        this.mc.field_1687.method_43129((class_1657)this.mc.field_1724, (class_1297)this.mc.field_1724, class_3417.field_14627, class_3419.field_15256, 3.0f, 1.0f);
                    }
                }
            } else {
                class_5250 text = class_2561.method_43470((String)event.entity.method_5864().method_5897().getString()).method_27692(class_124.field_1068);
                text.method_10852((class_2561)class_2561.method_43470((String)" has spawned at ").method_27692(class_124.field_1080));
                text.method_10852((class_2561)ChatUtils.formatCoords(event.entity.method_19538()));
                text.method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080));
                this.info((class_2561)text);
            }
        }
        if (this.pearl.get().booleanValue() && (class_12972 = event.entity) instanceof class_1684) {
            class_1684 pearl = (class_1684)class_12972;
            this.pearlStartPosMap.put(pearl.method_5628(), new class_243(pearl.method_23317(), pearl.method_23318(), pearl.method_23321()));
        }
    }

    @EventHandler
    private void onEntityRemoved(EntityRemovedEvent event) {
        class_1297 e;
        int i;
        if (!event.entity.method_5667().equals(this.mc.field_1724.method_5667()) && this.entities.get().contains(event.entity.method_5864()) && this.visualRange.get().booleanValue() && this.event.get() != Event.Spawn) {
            if (event.entity instanceof class_1657) {
                if (!(this.visualRangeIgnoreFriends.get().booleanValue() && Friends.get().isFriend((class_1657)event.entity) || this.visualRangeIgnoreFakes.get().booleanValue() && event.entity instanceof FakePlayerEntity)) {
                    ChatUtils.sendMsg(event.entity.method_5628() + 100, class_124.field_1080, "(highlight)%s(default) has left your visual range!", event.entity.method_5477().getString());
                    if (this.visualMakeSound.get().booleanValue()) {
                        this.mc.field_1687.method_43129((class_1657)this.mc.field_1724, (class_1297)this.mc.field_1724, class_3417.field_14627, class_3419.field_15256, 3.0f, 1.0f);
                    }
                }
            } else {
                class_5250 text = class_2561.method_43470((String)event.entity.method_5864().method_5897().getString()).method_27692(class_124.field_1068);
                text.method_10852((class_2561)class_2561.method_43470((String)" has despawned at ").method_27692(class_124.field_1080));
                text.method_10852((class_2561)ChatUtils.formatCoords(event.entity.method_19538()));
                text.method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080));
                this.info((class_2561)text);
            }
        }
        if (this.pearl.get().booleanValue() && this.pearlStartPosMap.containsKey(i = (e = event.entity).method_5628())) {
            class_1297 class_12972;
            class_1684 pearl = (class_1684)e;
            if (pearl.method_24921() != null && (class_12972 = pearl.method_24921()) instanceof class_1657) {
                class_1657 p = (class_1657)class_12972;
                double d = this.pearlStartPosMap.get(i).method_1022(e.method_19538());
                if (!(Friends.get().isFriend(p) && this.pearlIgnoreFriends.get().booleanValue() || p.equals((Object)this.mc.field_1724) && this.pearlIgnoreOwn.get().booleanValue())) {
                    this.info("(highlight)%s's(default) pearl landed at %d, %d, %d (highlight)(%.1fm away, travelled %.1fm)(default).", pearl.method_24921().method_5477().getString(), pearl.method_24515().method_10263(), pearl.method_24515().method_10264(), pearl.method_24515().method_10260(), Float.valueOf(pearl.method_5739((class_1297)this.mc.field_1724)), d);
                }
            }
            this.pearlStartPosMap.remove(i);
        }
    }

    @Override
    public void onActivate() {
        this.totemPopMap.clear();
        this.chatIdMap.clear();
        this.pearlStartPosMap.clear();
    }

    @EventHandler
    private void onGameJoin(GameJoinedEvent event) {
        this.totemPopMap.clear();
        this.chatIdMap.clear();
        this.pearlStartPosMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onReceivePacket(PacketEvent.Receive event) {
        if (!this.totemPops.get().booleanValue()) {
            return;
        }
        class_2596<?> class_25962 = event.packet;
        if (!(class_25962 instanceof class_2663)) {
            return;
        }
        class_2663 p = (class_2663)class_25962;
        if (p.method_11470() != 35) {
            return;
        }
        class_1297 entity = p.method_11469((class_1937)this.mc.field_1687);
        if (!(entity instanceof class_1657)) {
            return;
        }
        if (entity.equals((Object)this.mc.field_1724) && this.totemsIgnoreOwn.get() != false || Friends.get().isFriend((class_1657)entity) && this.totemsIgnoreOthers.get() != false || !Friends.get().isFriend((class_1657)entity) && this.totemsIgnoreFriends.get().booleanValue()) {
            return;
        }
        Object2IntMap<UUID> object2IntMap = this.totemPopMap;
        synchronized (object2IntMap) {
            int pops = this.totemPopMap.getOrDefault((Object)entity.method_5667(), 0);
            this.totemPopMap.put((Object)entity.method_5667(), ++pops);
            ChatUtils.sendMsg(this.getChatId(entity), class_124.field_1080, "(highlight)%s (default)popped (highlight)%d (default)%s.", entity.method_5477().getString(), pops, pops == 1 ? "totem" : "totems");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.totemPops.get().booleanValue()) {
            return;
        }
        Object2IntMap<UUID> object2IntMap = this.totemPopMap;
        synchronized (object2IntMap) {
            for (class_1657 player : this.mc.field_1687.method_18456()) {
                if (!this.totemPopMap.containsKey((Object)player.method_5667()) || player.field_6213 <= 0 && !(player.method_6032() <= 0.0f)) continue;
                int pops = this.totemPopMap.removeInt((Object)player.method_5667());
                ChatUtils.sendMsg(this.getChatId((class_1297)player), class_124.field_1080, "(highlight)%s (default)died after popping (highlight)%d (default)%s.", player.method_5477().getString(), pops, pops == 1 ? "totem" : "totems");
                this.chatIdMap.removeInt((Object)player.method_5667());
            }
        }
    }

    private int getChatId(class_1297 entity) {
        return this.chatIdMap.computeIfAbsent((Object)entity.method_5667(), value -> this.random.nextInt());
    }

    public static enum Event {
        Spawn,
        Despawn,
        Both;

    }
}

