/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.friends;

import com.mojang.util.UndashedUuid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.friends.Friend;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;

public class Friends
extends System<Friends>
implements Iterable<Friend> {
    private final List<Friend> friends = new ArrayList<Friend>();

    public Friends() {
        super("friends");
    }

    public static Friends get() {
        return Systems.get(Friends.class);
    }

    public boolean add(Friend friend) {
        if (friend.name.isEmpty() || friend.name.contains(" ")) {
            return false;
        }
        if (!this.friends.contains(friend)) {
            this.friends.add(friend);
            this.save();
            return true;
        }
        return false;
    }

    public boolean remove(Friend friend) {
        if (this.friends.remove(friend)) {
            this.save();
            return true;
        }
        return false;
    }

    public Friend get(String name) {
        for (Friend friend : this.friends) {
            if (!friend.name.equals(name)) continue;
            return friend;
        }
        return null;
    }

    public Friend get(class_1657 player) {
        return this.get(player.method_5477().getString());
    }

    public Friend get(class_640 player) {
        return this.get(player.method_2966().getName());
    }

    public boolean isFriend(class_1657 player) {
        return player != null && this.get(player) != null;
    }

    public boolean isFriend(class_640 player) {
        return this.get(player) != null;
    }

    public boolean shouldAttack(class_1657 player) {
        return !this.isFriend(player);
    }

    public int count() {
        return this.friends.size();
    }

    public boolean isEmpty() {
        return this.friends.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Friend> iterator() {
        return this.friends.iterator();
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10566("friends", (class_2520)NbtUtils.listToTag(this.friends));
        return tag;
    }

    @Override
    public Friends fromTag(class_2487 tag) {
        this.friends.clear();
        for (class_2520 itemTag : tag.method_10554("friends", 10)) {
            String name;
            class_2487 friendTag = (class_2487)itemTag;
            if (!friendTag.method_10545("name") || this.get(name = friendTag.method_10558("name")) != null) continue;
            String uuid = friendTag.method_10558("id");
            Friend friend = !uuid.isBlank() ? new Friend(name, UndashedUuid.fromStringLenient((String)uuid)) : new Friend(name);
            this.friends.add(friend);
        }
        Collections.sort(this.friends);
        MeteorExecutor.execute(() -> this.friends.forEach(Friend::updateInfo));
        return this;
    }
}

