/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.accounts.types;

import com.mojang.util.UndashedUuid;
import java.util.Optional;
import meteordevelopment.meteorclient.systems.accounts.Account;
import meteordevelopment.meteorclient.systems.accounts.AccountType;
import meteordevelopment.meteorclient.systems.accounts.MicrosoftLogin;
import net.minecraft.class_320;

public class MicrosoftAccount
extends Account<MicrosoftAccount> {
    public MicrosoftAccount(String refreshToken) {
        super(AccountType.Microsoft, refreshToken);
    }

    @Override
    public boolean fetchInfo() {
        return this.auth() != null;
    }

    @Override
    public boolean login() {
        super.login();
        String token = this.auth();
        if (token == null) {
            return false;
        }
        this.cache.loadHead();
        MicrosoftAccount.setSession(new class_320(this.cache.username, UndashedUuid.fromStringLenient((String)this.cache.uuid), token, Optional.empty(), Optional.empty(), class_320.class_321.field_34962));
        return true;
    }

    private String auth() {
        MicrosoftLogin.LoginData data = MicrosoftLogin.login(this.name);
        if (!data.isGood()) {
            return null;
        }
        this.name = data.newRefreshToken;
        this.cache.username = data.username;
        this.cache.uuid = data.uuid;
        return data.mcToken;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MicrosoftAccount)) {
            return false;
        }
        return ((MicrosoftAccount)o).name.equals(this.name);
    }
}

