/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.accounts.types;

import com.mojang.authlib.Environment;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.util.UndashedUuid;
import java.lang.reflect.Type;
import java.util.Optional;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.YggdrasilMinecraftSessionServiceAccessor;
import meteordevelopment.meteorclient.systems.accounts.Account;
import meteordevelopment.meteorclient.systems.accounts.AccountType;
import meteordevelopment.meteorclient.systems.accounts.TokenAccount;
import meteordevelopment.meteorclient.utils.misc.NbtException;
import meteordevelopment.meteorclient.utils.network.Http;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_320;

public class EasyMCAccount
extends Account<EasyMCAccount>
implements TokenAccount {
    private static final Environment ENVIRONMENT = new Environment("https://sessionserver.easymc.io", "https://authserver.mojang.com", "EasyMC");
    private static final YggdrasilAuthenticationService SERVICE = new YggdrasilAuthenticationService(((MinecraftClientAccessor)MeteorClient.mc).getProxy(), ENVIRONMENT);
    private String token;

    public EasyMCAccount(String token) {
        super(AccountType.EasyMC, token);
        this.token = token;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean fetchInfo() {
        if (this.name.length() == 43) {
            return true;
        }
        AuthResponse res = (AuthResponse)Http.post("https://api.easymc.io/v1/token/redeem").bodyJson("{\"token\":\"" + this.name + "\"}").sendJson((Type)((Object)AuthResponse.class));
        if (res != null) {
            this.cache.username = res.mcName;
            this.cache.uuid = res.uuid;
            this.name = res.session;
            return true;
        }
        return false;
    }

    @Override
    public boolean login() {
        EasyMCAccount.applyLoginEnvironment(SERVICE, (MinecraftSessionService)YggdrasilMinecraftSessionServiceAccessor.createYggdrasilMinecraftSessionService(SERVICE.getServicesKeySet(), SERVICE.getProxy(), ENVIRONMENT));
        EasyMCAccount.setSession(new class_320(this.cache.username, UndashedUuid.fromStringLenient((String)this.cache.uuid), this.name, Optional.empty(), Optional.empty(), class_320.class_321.field_1988));
        this.cache.loadHead();
        return true;
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.type.name());
        tag.method_10582("name", this.name);
        tag.method_10582("token", this.token);
        tag.method_10566("cache", (class_2520)this.cache.toTag());
        return tag;
    }

    @Override
    public EasyMCAccount fromTag(class_2487 tag) {
        if (!(tag.method_10545("name") && tag.method_10545("cache") && tag.method_10545("token"))) {
            throw new NbtException();
        }
        this.name = tag.method_10558("name");
        this.token = tag.method_10558("token");
        this.cache.fromTag(tag.method_10562("cache"));
        return this;
    }

    private static class AuthResponse {
        public String mcName;
        public String uuid;
        public String session;
        public String message;

        private AuthResponse() {
        }
    }
}

