/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin.sodium;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.FluidRenderer;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import meteordevelopment.meteorclient.systems.modules.world.Ambience;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidRenderer.class}, remap=false)
public abstract class SodiumFluidRendererMixin {
    @Final
    @Shadow
    private int[] quadColors;
    @Unique
    private Ambience ambience;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo info) {
        this.ambience = Modules.get().get(Ambience.class);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRender(WorldSlice world, class_3610 fluidState, class_2338 blockPos, class_2338 offset, ChunkBuildBuffers buffers, CallbackInfo info) {
        int alpha = Xray.getAlpha(fluidState.method_15759(), blockPos);
        if (alpha == 0) {
            info.cancel();
        }
    }

    @Inject(method={"updateQuad"}, at={@At(value="TAIL")})
    private void onUpdateQuad(ModelQuadView quad, WorldSlice world, class_2338 pos, LightPipeline lighter, class_2350 dir, float brightness, ColorProvider<class_3610> colorProvider, class_3610 fluidState, CallbackInfo info) {
        if (this.ambience.isActive() && this.ambience.customLavaColor.get().booleanValue() && fluidState.method_15767(class_3486.field_15518)) {
            Color c = this.ambience.lavaColor.get();
            Arrays.fill(this.quadColors, ColorABGR.pack((int)c.r, (int)c.g, (int)c.b, (int)c.a));
        }
    }
}

