/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.mixin.MapRendererAccessor;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_330;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SaveMapCommand
extends Command {
    private static final SimpleCommandExceptionType MAP_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You must be holding a filled map."));
    private static final SimpleCommandExceptionType OOPS = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Something went wrong."));
    private final PointerBuffer filters = BufferUtils.createPointerBuffer((int)1);

    public SaveMapCommand() {
        super("save-map", "Saves a map to an image.", "sm");
        ByteBuffer pngFilter = MemoryUtil.memASCII((CharSequence)"*.png");
        this.filters.put(pngFilter);
        this.filters.rewind();
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        ((LiteralArgumentBuilder)builder.executes(context -> {
            class_22 state = this.getMapState();
            if (state == null) {
                throw MAP_NOT_FOUND.create();
            }
            class_1799 map = this.getMap();
            String path = this.getPath();
            if (path == null) {
                throw OOPS.create();
            }
            this.saveMap(map, state, path, 128);
            return 1;
        })).then(SaveMapCommand.argument("scale", IntegerArgumentType.integer((int)1)).executes(context -> {
            int scale = IntegerArgumentType.getInteger((CommandContext)context, (String)"scale");
            class_22 state = this.getMapState();
            if (state == null) {
                throw MAP_NOT_FOUND.create();
            }
            class_1799 map = this.getMap();
            String path = this.getPath();
            if (path == null) {
                throw OOPS.create();
            }
            this.saveMap(map, state, path, scale);
            return 1;
        }));
    }

    private void saveMap(@NotNull class_1799 map, class_22 state, String path, int scale) {
        class_330 mapRenderer = SaveMapCommand.mc.field_1773.method_3194();
        class_330.class_331 texture = ((MapRendererAccessor)mapRenderer).invokeGetMapTexture((class_9209)map.method_57824(class_9334.field_49646), state);
        int[] data = texture.field_2048.method_4525().method_4322();
        BufferedImage image = new BufferedImage(128, 128, 2);
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), data, 0, 128);
        BufferedImage scaledImage = new BufferedImage(scale, scale, 2);
        if (scale != 128) {
            Graphics2D g = scaledImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage(image, 0, 0, scale, scale, null);
            g.dispose();
        }
        try {
            ImageIO.write((RenderedImage)(scale == 128 ? image : scaledImage), "png", new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private class_22 getMapState() {
        class_1799 map = this.getMap();
        if (map == null) {
            return null;
        }
        return class_1806.method_7997((class_9209)((class_9209)map.method_57824(class_9334.field_49646)), (class_1937)SaveMapCommand.mc.field_1687);
    }

    @Nullable
    private String getPath() {
        Object path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save image", null, (PointerBuffer)this.filters, null);
        if (path == null) {
            return null;
        }
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return path;
    }

    @Nullable
    private class_1799 getMap() {
        class_1799 itemStack = SaveMapCommand.mc.field_1724.method_6047();
        if (itemStack.method_7909() == class_1802.field_8204) {
            return itemStack;
        }
        itemStack = SaveMapCommand.mc.field_1724.method_6079();
        if (itemStack.method_7909() == class_1802.field_8204) {
            return itemStack;
        }
        return null;
    }
}

