/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.ComponentMapArgumentType;
import meteordevelopment.meteorclient.utils.misc.text.MeteorClickEvent;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2203;
import net.minecraft.class_2378;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_3169;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7079;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import net.minecraft.class_9336;

public class NbtCommand
extends Command {
    private static final DynamicCommandExceptionType MALFORMED_ITEM_EXCEPTION = new DynamicCommandExceptionType(error -> class_2561.method_54159((String)"arguments.item.malformed", (Object[])new Object[]{error}));
    private final class_2561 copyButton = class_2561.method_43470((String)"NBT").method_10862(class_2583.field_24360.method_27706(class_124.field_1073).method_10958((class_2558)new MeteorClickEvent(class_2558.class_2559.field_11750, this.toString("copy"))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy the NBT data to your clipboard."))));

    public NbtCommand() {
        super("nbt", "Modifies NBT data for an item, example: .nbt add {display:{Name:'{\"text\":\"$cRed Name\"}'}}", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(NbtCommand.literal("add").then(NbtCommand.argument("component", ComponentMapArgumentType.componentMap(REGISTRY_ACCESS)).executes(ctx -> {
            class_1799 stack = NbtCommand.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                class_9323 itemComponents = stack.method_57353();
                class_9323 newComponents = ComponentMapArgumentType.getComponentMap(ctx, "component");
                class_9323 testComponents = class_9323.method_59771((class_9323)itemComponents, (class_9323)newComponents);
                DataResult dataResult = class_1799.method_59691((class_9323)testComponents);
                dataResult.getOrThrow(arg_0 -> ((DynamicCommandExceptionType)MALFORMED_ITEM_EXCEPTION).create(arg_0));
                stack.method_57365(testComponents);
                this.setStack(stack);
            }
            return 1;
        })));
        builder.then(NbtCommand.literal("set").then(NbtCommand.argument("component", ComponentMapArgumentType.componentMap(REGISTRY_ACCESS)).executes(ctx -> {
            class_1799 stack = NbtCommand.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                class_9323 components = ComponentMapArgumentType.getComponentMap(ctx, "component");
                class_9335 stackComponents = (class_9335)stack.method_57353();
                DataResult dataResult = class_1799.method_59691((class_9323)components);
                dataResult.getOrThrow(arg_0 -> ((DynamicCommandExceptionType)MALFORMED_ITEM_EXCEPTION).create(arg_0));
                class_9326.class_9327 changesBuilder = class_9326.method_57841();
                Set types = stackComponents.method_57831();
                for (class_9336 entry : components) {
                    changesBuilder.method_57855(entry);
                    types.remove(entry.comp_2443());
                }
                for (class_9331 type : types) {
                    changesBuilder.method_57853(type);
                }
                stackComponents.method_57936(changesBuilder.method_57852());
                this.setStack(stack);
            }
            return 1;
        })));
        builder.then(NbtCommand.literal("remove").then((ArgumentBuilder)((RequiredArgumentBuilder)NbtCommand.argument("component", class_7079.method_41224((class_5321)class_7924.field_49659)).executes(ctx -> {
            class_1799 stack = NbtCommand.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                class_5321 componentTypeKey = (class_5321)ctx.getArgument("component", class_5321.class);
                class_9331 componentType = (class_9331)class_7923.field_49658.method_29107(componentTypeKey);
                class_9335 components = (class_9335)stack.method_57353();
                components.method_57936(class_9326.method_57841().method_57853(componentType).method_57852());
                this.setStack(stack);
            }
            return 1;
        })).suggests((ctx, suggestionsBuilder) -> {
            class_1799 stack = NbtCommand.mc.field_1724.method_31548().method_7391();
            if (stack != class_1799.field_8037) {
                class_9323 components = stack.method_57353();
                String remaining = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
                class_2172.method_9268(components.method_57831().stream().map(arg_0 -> ((class_2378)class_7923.field_49658).method_47983(arg_0)).toList(), (String)remaining, entry -> {
                    if (entry.method_40230().isPresent()) {
                        return ((class_5321)entry.method_40230().get()).method_29177();
                    }
                    return null;
                }, entry -> {
                    class_9331 dataComponentType = (class_9331)entry.comp_349();
                    if (dataComponentType.method_57875() != null && entry.method_40230().isPresent()) {
                        suggestionsBuilder.suggest(((class_5321)entry.method_40230().get()).method_29177().toString());
                    }
                });
            }
            return suggestionsBuilder.buildFuture();
        })));
        builder.then(NbtCommand.literal("get").executes(context -> {
            class_3169 dataCommandObject = new class_3169((class_1297)NbtCommand.mc.field_1724);
            class_2203.class_2209 handPath = class_2203.class_2209.method_58472((String)"SelectedItem");
            class_5250 text = class_2561.method_43473().method_10852(this.copyButton);
            try {
                List nbtElement = handPath.method_9366((class_2520)dataCommandObject.method_13881());
                if (!nbtElement.isEmpty()) {
                    text.method_27693(" ").method_10852(class_2512.method_32270((class_2520)((class_2520)nbtElement.getFirst())));
                }
            }
            catch (CommandSyntaxException e) {
                text.method_27693("{}");
            }
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(NbtCommand.literal("copy").executes(context -> {
            class_3169 dataCommandObject = new class_3169((class_1297)NbtCommand.mc.field_1724);
            class_2203.class_2209 handPath = class_2203.class_2209.method_58472((String)"SelectedItem");
            class_5250 text = class_2561.method_43473().method_10852(this.copyButton);
            String nbt = "{}";
            try {
                List nbtElement = handPath.method_9366((class_2520)dataCommandObject.method_13881());
                if (!nbtElement.isEmpty()) {
                    text.method_27693(" ").method_10852(class_2512.method_32270((class_2520)((class_2520)nbtElement.getFirst())));
                    nbt = ((class_2520)nbtElement.getFirst()).toString();
                }
            }
            catch (CommandSyntaxException e) {
                text.method_27693("{}");
            }
            NbtCommand.mc.field_1774.method_1455(nbt);
            text.method_27693(" data copied!");
            this.info((class_2561)text);
            return 1;
        }));
        builder.then(NbtCommand.literal("count").then(NbtCommand.argument("count", IntegerArgumentType.integer((int)-127, (int)127)).executes(context -> {
            class_1799 stack = NbtCommand.mc.field_1724.method_31548().method_7391();
            if (this.validBasic(stack)) {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                stack.method_7939(count);
                this.setStack(stack);
                this.info("Set mainhand stack count to %s.", count);
            }
            return 1;
        })));
    }

    private void setStack(class_1799 stack) {
        NbtCommand.mc.field_1724.field_3944.method_52787((class_2596)new class_2873(36 + NbtCommand.mc.field_1724.method_31548().field_7545, stack));
    }

    private boolean validBasic(class_1799 stack) {
        if (!NbtCommand.mc.field_1724.method_31549().field_7477) {
            this.error("Creative mode only.", new Object[0]);
            return false;
        }
        if (stack == class_1799.field_8037) {
            this.error("You must hold an item in your main hand.", new Object[0]);
            return false;
        }
        return true;
    }
}

