/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.PlayerListEntryArgumentType;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_640;

public class NameHistoryCommand
extends Command {
    public NameHistoryCommand() {
        super("name-history", "Provides a list of a players previous names from the laby.net api.", "history", "names");
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(NameHistoryCommand.argument("player", PlayerListEntryArgumentType.create()).executes(context -> {
            MeteorExecutor.execute(() -> {
                class_640 lookUpTarget = PlayerListEntryArgumentType.get(context);
                UUID uuid = lookUpTarget.method_2966().getId();
                NameHistory history = (NameHistory)Http.get("https://laby.net/api/v2/user/" + String.valueOf(uuid) + "/get-profile").sendJson((Type)((Object)NameHistory.class));
                if (history == null || history.username_history == null || history.username_history.length == 0) {
                    this.error("There was an error fetching that users name history.", new Object[0]);
                    return;
                }
                String name = lookUpTarget.method_2966().getName();
                class_5250 initial = class_2561.method_43470((String)name);
                initial.method_10852((class_2561)class_2561.method_43470((String)(name.endsWith("s") ? "'" : "'s")));
                Color nameColor = PlayerUtils.getPlayerColor(NameHistoryCommand.mc.field_1687.method_18470(uuid), Utils.WHITE);
                initial.method_10862(initial.method_10866().method_27703(class_5251.method_27717((int)nameColor.getPacked())).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://laby.net/@" + name)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"View on laby.net").method_27692(class_124.field_1054).method_27692(class_124.field_1056))));
                this.info((class_2561)initial.method_10852((class_2561)class_2561.method_43470((String)" Username History:").method_27692(class_124.field_1080)));
                for (Name entry : history.username_history) {
                    class_5250 nameText = class_2561.method_43470((String)entry.name);
                    nameText.method_27692(class_124.field_1075);
                    if (entry.changed_at != null && entry.changed_at.getTime() != 0L) {
                        class_5250 changed = class_2561.method_43470((String)"Changed at: ");
                        changed.method_27692(class_124.field_1080);
                        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss, dd/MM/yyyy");
                        changed.method_10852((class_2561)class_2561.method_43470((String)formatter.format(entry.changed_at)).method_27692(class_124.field_1068));
                        nameText.method_10862(nameText.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)changed)));
                    }
                    if (!entry.accurate) {
                        class_5250 text = class_2561.method_43470((String)"*").method_27692(class_124.field_1068);
                        text.method_10862(text.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"This name history entry is not accurate according to laby.net"))));
                        nameText.method_10852((class_2561)text);
                    }
                    ChatUtils.sendMsg((class_2561)nameText);
                }
            });
            return 1;
        }));
    }

    private static class NameHistory {
        public Name[] username_history;

        private NameHistory() {
        }
    }

    private static class Name {
        public String name;
        public Date changed_at;
        public boolean accurate;

        private Name() {
        }
    }
}

