/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2172;
import net.minecraft.class_304;

public class InputCommand
extends Command {
    private static final List<KeypressHandler> activeHandlers = new ArrayList<KeypressHandler>();
    private static final Map<class_304, String> keys = Map.of(InputCommand.mc.field_1690.field_1894, "forwards", InputCommand.mc.field_1690.field_1881, "backwards", InputCommand.mc.field_1690.field_1913, "left", InputCommand.mc.field_1690.field_1849, "right", InputCommand.mc.field_1690.field_1903, "jump", InputCommand.mc.field_1690.field_1832, "sneak", InputCommand.mc.field_1690.field_1904, "use", InputCommand.mc.field_1690.field_1886, "attack");

    public InputCommand() {
        super("input", "Keyboard input simulation.", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        for (Map.Entry<class_304, String> keyBinding : keys.entrySet()) {
            builder.then(InputCommand.literal(keyBinding.getValue()).then(InputCommand.argument("ticks", IntegerArgumentType.integer((int)1)).executes(context -> {
                activeHandlers.add(new KeypressHandler((class_304)keyBinding.getKey(), (Integer)context.getArgument("ticks", Integer.class)));
                return 1;
            })));
        }
        builder.then(InputCommand.literal("clear").executes(ctx -> {
            if (activeHandlers.isEmpty()) {
                this.warning("No active keypress handlers.", new Object[0]);
            } else {
                this.info("Cleared all keypress handlers.", new Object[0]);
                activeHandlers.forEach(MeteorClient.EVENT_BUS::unsubscribe);
                activeHandlers.clear();
            }
            return 1;
        }));
        builder.then(InputCommand.literal("list").executes(ctx -> {
            if (activeHandlers.isEmpty()) {
                this.warning("No active keypress handlers.", new Object[0]);
            } else {
                this.info("Active keypress handlers: ", new Object[0]);
                for (int i = 0; i < activeHandlers.size(); ++i) {
                    KeypressHandler handler = activeHandlers.get(i);
                    this.info("(highlight)%d(default) - (highlight)%s %d(default) ticks left out of (highlight)%d(default).", i, keys.get(handler.key), handler.ticks, handler.totalTicks);
                }
            }
            return 1;
        }));
        builder.then(InputCommand.literal("remove").then(InputCommand.argument("index", IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index");
            if (index >= activeHandlers.size()) {
                this.warning("Index out of range.", new Object[0]);
            } else {
                this.info("Removed keypress handler.", new Object[0]);
                MeteorClient.EVENT_BUS.unsubscribe(activeHandlers.get(index));
                activeHandlers.remove(index);
            }
            return 1;
        })));
    }

    private static class KeypressHandler {
        private final class_304 key;
        private final int totalTicks;
        private int ticks;

        public KeypressHandler(class_304 key, int ticks) {
            this.key = key;
            this.totalTicks = ticks;
            this.ticks = ticks;
            MeteorClient.EVENT_BUS.subscribe(this);
        }

        @EventHandler
        private void onTick(TickEvent.Post event) {
            if (this.ticks-- > 0) {
                this.key.method_23481(true);
            } else {
                this.key.method_23481(false);
                MeteorClient.EVENT_BUS.unsubscribe(this);
                activeHandlers.remove(this);
            }
        }
    }
}

