# OpenSSH Username Enumeration (CVE-2018-15473)

[中文版本(Chinese version)](README.zh-cn.md)

OpenSSH is a suite of secure networking utilities based on the Secure Shell protocol, which provides a secure channel over an unsecured network in a client–server architecture.

CVE-2018-15473 is a medium-severity vulnerability affecting OpenSSH versions up to and including 7.7. This vulnerability allows user enumeration due to the system not delaying bailout for an invalid authenticating user until after the packet containing the request has been fully parsed. As a result, a remote attacker can test whether a certain user exists on a target OpenSSH server.

References:

- http://openwall.com/lists/oss-security/2018/08/15/5
- https://github.com/Rhynorater/CVE-2018-15473-Exploit
- https://www.anquanke.com/post/id/157607

## Vulnerable environment

Execute following commands to start a OpenSSH server 7.7p1:

```
docker compose build
docker compose up -d
```

After the server is started, you can log in to OpenSSH server by `ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null root@your-ip -p20022` and password `vulhub`.

## Vulnerability reproduce

Use [CVE-2018-15473-Exploit](https://github.com/Rhynorater/CVE-2018-15473-Exploit) to enumerate usernames in the dictionary:

```
python3 sshUsernameEnumExploit.py --port 20022 --userList exampleInput.txt your-ip
```

![](1.png)

As you can see, `root`、`example`、`vulhub`、`nobody` are existing usernames, `rootInvalid`、`user`、`phithon` are non-existent usernames.
