# Nginx Cache Leak by Integer Overflow (CVE-2017-7529)

[中文版本(Chinese version)](README.zh-cn.md)

Nginx is a web server that can be used as a reverse proxy, load balancer, mail proxy, and HTTP cache. When Nginx acts as a reverse proxy, it typically caches certain files, especially static files. The cached content is stored in files, with each cache file containing a "file header" + "HTTP response header" + "HTTP response body". If a subsequent request hits this cache file, Nginx will directly return the "HTTP response body" from the file to the user.

Nginx versions since 0.5.6 up to and including 1.13.2 are vulnerable to integer overflow vulnerability in nginx range filter module resulting into leak of potentially sensitive information triggered by specially crafted request.

If a request contains a Range header, Nginx will return content of specified length based on the start and end positions provided. However, if we construct two negative positions, such as (-600, -9223372036854774591), it becomes possible to read data from negative positions. If this request hits a cache file, we may be able to read the "file header" and "HTTP response header" that are located before the "HTTP response body" in the cache file.

References:

 - https://cert.360.cn/detailnews.html?id=b879782fbad4a7f773b6c18490d67ac7
 - http://galaxylab.org/cve-2017-7529-nginx%E6%95%B4%E6%95%B0%E6%BA%A2%E5%87%BA%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/

## Environment Setup

Run the following command to start a Nginx server version 1.13.2:

```
docker compose up -d
```

After the server starts, visit `http://your-ip:8080/` to see the Nginx default page, which is actually content reverse proxied from port 8081.

## Vulnerability Reproduce

Run `python3 poc.py http://your-ip:8080/` and check the returned results:

![](01.png)

As you can see, we've successfully read the "file header" and "HTTP response header" content located before the "HTTP response body" through out-of-bounds reading.

If the reading is incorrect, try adjusting the offset address (605) in poc.py.
