# Apache HTTPD 多后缀解析漏洞

[English](README.md)

Apache HTTPD 是一个广泛使用的开源Web服务器软件。这个漏洞与Apache HTTPD处理多后缀文件的机制有关。

Apache HTTPD支持一个文件拥有多个后缀，并为不同后缀执行不同的指令。当配置不当时，这个特性可能导致安全漏洞，使恶意文件绕过上传限制。例如，以下配置：

```
AddType text/html .html
AddLanguage zh-CN .cn
AddHandler application/x-httpd-php .php
```

服务器会从左到右处理多个后缀，如果任何后缀被配置为由特定处理器（如PHP）处理，那么无论该后缀在文件名中的位置如何，都会被执行。这意味着一个名为`malicious.php.jpg`的文件仍然会被作为PHP代码执行，从而可能绕过仅检查最后一个后缀的上传限制。

参考链接：

- [Apache HTTP Server文档 - MultiViews](https://httpd.apache.org/docs/current/content-negotiation.html#multiviews)
- [OWASP文件上传漏洞](https://owasp.org/www-community/vulnerabilities/Unrestricted_File_Upload)

## 环境搭建

执行以下命令启动一个包含PHP 7.3环境的Apache服务器：

```
docker compose up -d
```

## 漏洞复现

首先，在浏览器中访问`http://your-ip/uploadfiles/apache.php.jpeg`。你会发现，尽管文件具有`.jpeg`后缀，但它被作为PHP代码执行并显示了phpinfo()页面。

要主动利用这个漏洞，访问`http://your-ip/index.php`，你会看到一个带有后缀白名单验证的文件上传界面。上传功能只检查最后一个后缀，且不会重命名上传的文件。通过上传具有多个后缀的文件（如`shell.php.jpg`或`shell.php.jpeg`），我们可以绕过后缀检查，同时确保文件被Apache作为PHP代码执行。

![上传界面](1.png)

成功上传后，通过浏览器访问该文件将执行PHP代码，证实了漏洞的存在：

![漏洞证明](2.png)
