# GhostScript Sandbox Bypass Command Execution (CVE-2019-6116)

[中文版本(Chinese version)](README.zh-cn.md)

GhostScript is a suite of software based on an interpreter for Adobe Systems' PostScript and PDF page description languages. It is widely used by many image processing libraries such as ImageMagick and Python PIL.

On January 23rd, 2019, Artifex officially merged six fixes into the master branch of GhostScript to address CVE-2019-6116. This vulnerability was reported by Google security researcher Tavis on December 3rd, 2018. The vulnerability allows attackers to bypass GhostScript's security sandbox, leading to arbitrary command execution and file reading capabilities.

References:

- <https://bugs.chromium.org/p/project-zero/issues/detail?id=1729&desc=2>
- <https://www.anquanke.com/post/id/170255>

## Environment Setup

Execute the following command to start a vulnerable environment (including GhostScript 9.26 and ImageMagick 7.0.8-27):

```
docker compose up -d
```

After the server is started, visit `http://your-ip:8080` to see an upload component.

## Vulnerability Reproduction

Upload the provided [POC](poc.png) file to execute the command `id > /tmp/success`.

![](1.png)

You can also test this vulnerability using the command line:

```
docker run -it --rm --name uu -v `pwd`/poc.png:/tmp/poc.png vulhub/imagemagick:7.0.8-27-php identify /tmp/poc.png
```

The command will be successfully executed.

![](2.png)
