# GhostScript 沙箱绕过命令执行漏洞（CVE-2018-16509）

GhostScript 是一套基于 Adobe Systems 的 PostScript 和 PDF 页面描述语言解释器的软件。它被许多图像处理库广泛使用，如 ImageMagick、Python PIL 等。

2018年8月21日，安全研究员 Tavis Ormandy 通过公开邮件列表披露了 GhostScript 的安全沙箱可以被绕过的漏洞。通过构造恶意的图片内容，攻击者可以实现命令执行、文件读取和文件删除等操作。

参考链接：

- <http://seclists.org/oss-sec/2018/q3/142>
- <https://bugs.chromium.org/p/project-zero/issues/detail?id=1640>

## 环境搭建

执行如下命令启动漏洞环境（其中包括 GhostScript 9.23 和 ImageMagick 7.0.8）：

```
docker compose up -d
```

环境启动后，访问 `http://your-ip:8080` 将看到一个文件上传组件。

## 漏洞复现

上传 [poc.png](poc.png) 文件，该文件将执行命令 `id > /tmp/success && cat /tmp/success`。使用 `docker compose exec web bash` 进入容器后，可以看到 /tmp/success 文件已被创建。

![](1.png)

你也可以使用命令行来测试该漏洞：

```
docker run -it --rm --name im -v `pwd`/poc.png:/poc.png vulhub/imagemagick:7.0.8-10 convert /poc.png /poc.gif
```

从执行结果可以看到，`id` 命令已被成功执行。

![](2.png)
