# Apache Airflow Command Injection in Example Dag (CVE-2020-11978)

[中文版本(Chinese version)](README.zh-cn.md)

Apache Airflow is an open source, distributed task scheduling framework. In the version prior to 1.10.10, there is a command injection vulnerability in the example DAG `example_trigger_target_dag`, which caused attackers to execute arbitrary commands in the worker process.

Since there are many components to be started, it may be a bit stuck. Please prepare more than 2G of memory for the use of the virtual machine.

References:

- <https://lists.apache.org/thread/cn57zwylxsnzjyjztwqxpmly0x9q5ljx>
- <https://github.com/pberba/CVE-2020-11978>

## Vulnerability Environment

Execute the following commands to start airflow 1.10.10:

```bash
#Initialize the database
docker compose run airflow-init

#Start service
docker compose up -d
```

## Exploit

Visit `http://your-ip:8080` to see the airflow management terminal, and turn on the `example_trigger_target_dag` flag:

![](1.png)

Click the "triger" button on the right, then input the configuration JSON with the crafted payload `{"message":"'\";touch /tmp/airflow_dag_success;#"}`:

![](2.png)

Wait a few seconds to see the execution of "success":

![](3.png)

Go to the CeleryWorker container to see the result, `touch /tmp/airflow_dag_success` has been successfully executed:

```
docker compose exec airflow-worker ls -l /tmp
```

![](4.png)
