/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.util;

import com.ctrip.framework.apollo.portal.constant.RoleType;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Iterator;

public class RoleUtils {
    private static final Joiner STRING_JOINER = Joiner.on((String)"+").skipNulls();
    private static final Splitter STRING_SPLITTER = Splitter.on((String)"+").omitEmptyStrings().trimResults();

    public static String buildAppMasterRoleName(String appId) {
        return STRING_JOINER.join((Object)"Master", (Object)appId, new Object[0]);
    }

    public static String extractAppIdFromMasterRoleName(String masterRoleName) {
        Iterator parts = STRING_SPLITTER.split((CharSequence)masterRoleName).iterator();
        if (parts.hasNext() && ((String)parts.next()).equals("Master") && parts.hasNext()) {
            return (String)parts.next();
        }
        return null;
    }

    public static String extractAppIdFromRoleName(String roleName) {
        String roleType;
        Iterator parts = STRING_SPLITTER.split((CharSequence)roleName).iterator();
        if (parts.hasNext() && RoleType.isValidRoleType(roleType = (String)parts.next()) && parts.hasNext()) {
            return (String)parts.next();
        }
        return null;
    }

    public static String buildAppRoleName(String appId, String roleType) {
        return STRING_JOINER.join((Object)roleType, (Object)appId, new Object[0]);
    }

    public static String buildModifyNamespaceRoleName(String appId, String namespaceName) {
        return RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName, null);
    }

    public static String buildModifyNamespaceRoleName(String appId, String namespaceName, String env) {
        return STRING_JOINER.join((Object)"ModifyNamespace", (Object)appId, new Object[]{namespaceName, env});
    }

    public static String buildModifyDefaultNamespaceRoleName(String appId) {
        return STRING_JOINER.join((Object)"ModifyNamespace", (Object)appId, new Object[]{"application"});
    }

    public static String buildReleaseNamespaceRoleName(String appId, String namespaceName) {
        return RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName, null);
    }

    public static String buildReleaseNamespaceRoleName(String appId, String namespaceName, String env) {
        return STRING_JOINER.join((Object)"ReleaseNamespace", (Object)appId, new Object[]{namespaceName, env});
    }

    public static String buildNamespaceRoleName(String appId, String namespaceName, String roleType) {
        return RoleUtils.buildNamespaceRoleName(appId, namespaceName, roleType, null);
    }

    public static String buildNamespaceRoleName(String appId, String namespaceName, String roleType, String env) {
        return STRING_JOINER.join((Object)roleType, (Object)appId, new Object[]{namespaceName, env});
    }

    public static String buildReleaseDefaultNamespaceRoleName(String appId) {
        return STRING_JOINER.join((Object)"ReleaseNamespace", (Object)appId, new Object[]{"application"});
    }

    public static String buildNamespaceTargetId(String appId, String namespaceName) {
        return RoleUtils.buildNamespaceTargetId(appId, namespaceName, null);
    }

    public static String buildNamespaceTargetId(String appId, String namespaceName, String env) {
        return STRING_JOINER.join((Object)appId, (Object)namespaceName, new Object[]{env});
    }

    public static String buildDefaultNamespaceTargetId(String appId) {
        return STRING_JOINER.join((Object)appId, (Object)"application", new Object[0]);
    }

    public static String buildCreateApplicationRoleName(String permissionType, String permissionTargetId) {
        return STRING_JOINER.join((Object)permissionType, (Object)permissionTargetId, new Object[0]);
    }
}

