/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.util;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class RelativeDateFormat {
    private static final FastDateFormat TIMESTAMP_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final String ONE_SECOND_AGO = " seconds ago";
    private static final String ONE_MINUTE_AGO = " minutes ago";
    private static final String ONE_HOUR_AGO = " hours ago";
    private static final String ONE_DAY_AGO = " days ago";
    private static final String ONE_MONTH_AGO = " months ago";

    public static String format(Date date) {
        if (date.after(new Date())) {
            return "now";
        }
        long delta = new Date().getTime() - date.getTime();
        if (delta < 60000L) {
            long seconds = RelativeDateFormat.toSeconds(delta);
            return (seconds <= 0L ? 1L : seconds) + ONE_SECOND_AGO;
        }
        if (delta < 2700000L) {
            long minutes = RelativeDateFormat.toMinutes(delta);
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            long hours = RelativeDateFormat.toHours(delta);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        Date lastDayBeginTime = RelativeDateFormat.getDateOffset(-1);
        if (date.after(lastDayBeginTime)) {
            return "yesterday";
        }
        Date lastTwoDaysBeginTime = RelativeDateFormat.getDateOffset(-2);
        if (date.after(lastTwoDaysBeginTime)) {
            return "the day before yesterday";
        }
        if (delta < 2592000000L) {
            long days = RelativeDateFormat.toDays(delta);
            return (days <= 0L ? 1L : days) + ONE_DAY_AGO;
        }
        long months = RelativeDateFormat.toMonths(delta);
        if (months <= 3L) {
            return (months <= 0L ? 1L : months) + ONE_MONTH_AGO;
        }
        return TIMESTAMP_FORMAT.format(date);
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return RelativeDateFormat.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return RelativeDateFormat.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return RelativeDateFormat.toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return RelativeDateFormat.toDays(date) / 30L;
    }

    public static Date getDateOffset(int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, offset);
        return RelativeDateFormat.getDayBeginTime(calendar.getTime());
    }

    private static Date getDayBeginTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }
}

