/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.util;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.PropertiesUtil;
import com.ctrip.framework.apollo.portal.entity.bo.ItemBO;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class NamespaceBOUtils {
    static String convertNonProperties2configFileContent(NamespaceBO namespaceBO) {
        List<ItemBO> itemBOS = namespaceBO.getItems();
        for (ItemBO itemBO : itemBOS) {
            String key = itemBO.getItem().getKey();
            if (!"content".equals(key)) continue;
            return itemBO.getItem().getValue();
        }
        return "";
    }

    public static String convert2configFileContent(NamespaceBO namespaceBO) {
        String configFileContent;
        if (!ConfigFileFormat.Properties.equals((Object)ConfigFileFormat.fromString((String)namespaceBO.getFormat()))) {
            return NamespaceBOUtils.convertNonProperties2configFileContent(namespaceBO);
        }
        List<ItemBO> itemBOS = namespaceBO.getItems();
        Properties properties = new Properties();
        for (ItemBO itemBO : itemBOS) {
            String key = itemBO.getItem().getKey();
            String value = itemBO.getItem().getValue();
            properties.put(key, value);
        }
        try {
            configFileContent = PropertiesUtil.toString((Properties)properties);
        }
        catch (IOException e) {
            throw new IllegalStateException("convert properties to string fail.", e);
        }
        return configFileContent;
    }
}

