/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.util;

import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class ConfigFileUtils {
    public static void check(MultipartFile file) {
        ConfigFileUtils.checkEmpty(file);
        String originalFilename = file.getOriginalFilename();
        ConfigFileUtils.checkFormat(originalFilename);
    }

    static void checkEmpty(MultipartFile file) {
        if (file.isEmpty()) {
            throw new BadRequestException("The file is empty. " + file.getOriginalFilename());
        }
    }

    static void checkFormat(String originalFilename) {
        List fileNameSplit = Splitter.on((String)".").splitToList((CharSequence)originalFilename);
        if (fileNameSplit.size() <= 1) {
            throw new BadRequestException("The file format is invalid.");
        }
        for (String s : fileNameSplit) {
            if (!StringUtils.isEmpty((String)s)) continue;
            throw new BadRequestException("The file format is invalid.");
        }
    }

    static String[] getThreePart(String originalFilename) {
        return originalFilename.split("[+]");
    }

    static void checkThreePart(String originalFilename) {
        String[] parts = ConfigFileUtils.getThreePart(originalFilename);
        if (3 != parts.length) {
            throw new BadRequestException("file name [" + originalFilename + "] not valid");
        }
    }

    public static String getFormat(String originalFilename) {
        List fileNameSplit = Splitter.on((String)".").splitToList((CharSequence)originalFilename);
        if (fileNameSplit.size() <= 1) {
            throw new BadRequestException("The file format is invalid.");
        }
        return (String)fileNameSplit.get(fileNameSplit.size() - 1);
    }

    public static String getAppId(String originalFilename) {
        ConfigFileUtils.checkThreePart(originalFilename);
        return ConfigFileUtils.getThreePart(originalFilename)[0];
    }

    public static String getClusterName(String originalFilename) {
        ConfigFileUtils.checkThreePart(originalFilename);
        return ConfigFileUtils.getThreePart(originalFilename)[1];
    }

    public static String getNamespace(String originalFilename) {
        ConfigFileUtils.checkThreePart(originalFilename);
        String[] threeParts = ConfigFileUtils.getThreePart(originalFilename);
        String suffix = threeParts[2];
        if (!suffix.contains(".")) {
            throw new BadRequestException(originalFilename + " namespace and format is invalid!");
        }
        int lastDotIndex = suffix.lastIndexOf(".");
        String namespace = suffix.substring(0, lastDotIndex);
        String format = suffix.substring(lastDotIndex + 1);
        if (!ConfigFileFormat.isValidFormat((String)format)) {
            throw new BadRequestException(originalFilename + " format is invalid!");
        }
        ConfigFileFormat configFileFormat = ConfigFileFormat.fromString((String)format);
        if (configFileFormat.equals((Object)ConfigFileFormat.Properties)) {
            return namespace;
        }
        return namespace + "." + format;
    }

    public static String toFilename(String appId, String clusterName, String namespace, ConfigFileFormat configFileFormat) {
        String suffix = ConfigFileFormat.Properties.equals((Object)configFileFormat) ? "." + ConfigFileFormat.Properties.getValue() : "";
        return appId + "+" + clusterName + "+" + namespace + suffix;
    }

    public static String toFilePath(String ownerName, String appId, Env env, String configFilename) {
        return String.join((CharSequence)File.separator, ownerName, appId, env.getName(), configFilename);
    }
}

