/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.springsecurity;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.po.UserPO;
import com.ctrip.framework.apollo.portal.repository.UserRepository;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class SpringSecurityUserService
implements UserService {
    private PasswordEncoder encoder = new BCryptPasswordEncoder();
    private List<GrantedAuthority> authorities;
    @Autowired
    private JdbcUserDetailsManager userDetailsManager;
    @Autowired
    private UserRepository userRepository;

    @PostConstruct
    public void init() {
        this.authorities = new ArrayList<GrantedAuthority>();
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_user"));
    }

    @Transactional
    public void createOrUpdate(UserPO user) {
        String username = user.getUsername();
        User userDetails = new User(username, this.encoder.encode((CharSequence)user.getPassword()), this.authorities);
        if (this.userDetailsManager.userExists(username)) {
            this.userDetailsManager.updateUser((UserDetails)userDetails);
        } else {
            this.userDetailsManager.createUser((UserDetails)userDetails);
        }
        UserPO managedUser = this.userRepository.findByUsername(username);
        managedUser.setEmail(user.getEmail());
        this.userRepository.save(managedUser);
    }

    @Override
    public List<UserInfo> searchUsers(String keyword, int offset, int limit) {
        List<UserPO> users = StringUtils.isEmpty((String)keyword) ? this.userRepository.findFirst20ByEnabled(1) : this.userRepository.findByUsernameLikeAndEnabled("%" + keyword + "%", 1);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(users)) {
            return result;
        }
        result.addAll(users.stream().map(UserPO::toUserInfo).collect(Collectors.toList()));
        return result;
    }

    @Override
    public UserInfo findByUserId(String userId) {
        UserPO userPO = this.userRepository.findByUsername(userId);
        return userPO == null ? null : userPO.toUserInfo();
    }

    @Override
    public List<UserInfo> findByUserIds(List<String> userIds) {
        List<UserPO> users = this.userRepository.findByUsernameIn(userIds);
        if (CollectionUtils.isEmpty(users)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(users.stream().map(UserPO::toUserInfo).collect(Collectors.toList()));
        return result;
    }
}

