/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ldap;

import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.spi.configuration.LdapExtendProperties;
import com.ctrip.framework.apollo.portal.spi.configuration.LdapProperties;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.query.SearchScope;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.util.CollectionUtils;

public class LdapUserService
implements UserService {
    @Autowired
    private LdapProperties ldapProperties;
    @Autowired
    private LdapExtendProperties ldapExtendProperties;
    @Value(value="${spring.ldap.base}")
    private String base;
    @Value(value="${ldap.mapping.objectClass}")
    private String objectClassAttrName;
    @Value(value="${ldap.mapping.loginId}")
    private String loginIdAttrName;
    @Value(value="${ldap.mapping.userDisplayName}")
    private String userDisplayNameAttrName;
    @Value(value="${ldap.mapping.email}")
    private String emailAttrName;
    @Value(value="${ldap.mapping.rdnKey:}")
    private String rdnKey;
    @Value(value="#{'${ldap.filter.memberOf:}'.split('\\|')}")
    private String[] memberOf;
    @Value(value="${ldap.group.groupBase:}")
    private String groupBase;
    @Value(value="${ldap.group.groupSearch:}")
    private String groupSearch;
    @Value(value="${ldap.group.groupMembership:}")
    private String groupMembershipAttrName;
    @Autowired
    private LdapTemplate ldapTemplate;
    private static final String MEMBER_OF_ATTR_NAME = "memberOf";
    private static final String MEMBER_UID_ATTR_NAME = "memberUid";
    private ContextMapper<UserInfo> ldapUserInfoMapper = ctx -> {
        DirContextAdapter contextAdapter = (DirContextAdapter)ctx;
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(contextAdapter.getStringAttribute(this.loginIdAttrName));
        userInfo.setName(contextAdapter.getStringAttribute(this.userDisplayNameAttrName));
        userInfo.setEmail(contextAdapter.getStringAttribute(this.emailAttrName));
        return userInfo;
    };

    private ContainerCriteria ldapQueryCriteria() {
        ContainerCriteria criteria = LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).where("objectClass").is(this.objectClassAttrName);
        if (this.memberOf.length > 0 && !StringUtils.isEmpty((String)this.memberOf[0])) {
            ContainerCriteria memberOfFilters = LdapQueryBuilder.query().where(MEMBER_OF_ATTR_NAME).is(this.memberOf[0]);
            Arrays.stream(this.memberOf).skip(1L).forEach(filter -> memberOfFilters.or(MEMBER_OF_ATTR_NAME).is(filter));
            criteria.and(memberOfFilters);
        }
        return criteria;
    }

    private UserInfo lookupUser(String member, List<String> userIds) {
        return (UserInfo)this.ldapTemplate.lookup(member, attributes -> {
            Attribute userDisplayNameAttribute;
            Attribute loginIdAttribute;
            UserInfo tmp = new UserInfo();
            Attribute emailAttribute = attributes.get(this.emailAttrName);
            if (emailAttribute != null && emailAttribute.get() != null) {
                tmp.setEmail(emailAttribute.get().toString());
            }
            if ((loginIdAttribute = attributes.get(this.loginIdAttrName)) != null && loginIdAttribute.get() != null) {
                tmp.setUserId(loginIdAttribute.get().toString());
            }
            if ((userDisplayNameAttribute = attributes.get(this.userDisplayNameAttrName)) != null && userDisplayNameAttribute.get() != null) {
                tmp.setName(userDisplayNameAttribute.get().toString());
            }
            if (userIds != null) {
                if (userIds.stream().anyMatch(c -> c.equals(tmp.getUserId()))) {
                    return tmp;
                }
                return null;
            }
            return tmp;
        });
    }

    private UserInfo searchUserById(String userId) {
        return (UserInfo)this.ldapTemplate.searchForObject((LdapQuery)LdapQueryBuilder.query().where(this.loginIdAttrName).is(userId), ctx -> {
            UserInfo userInfo = new UserInfo();
            DirContextAdapter contextAdapter = (DirContextAdapter)ctx;
            userInfo.setEmail(contextAdapter.getStringAttribute(this.emailAttrName));
            userInfo.setName(contextAdapter.getStringAttribute(this.userDisplayNameAttrName));
            userInfo.setUserId(contextAdapter.getStringAttribute(this.loginIdAttrName));
            return userInfo;
        });
    }

    private List<UserInfo> searchUserInfoByGroup(String groupBase, String groupSearch, String keyword, List<String> userIds) {
        return (List)this.ldapTemplate.searchForObject(groupBase, groupSearch, ctx -> {
            ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
            if (!MEMBER_UID_ATTR_NAME.equals(this.groupMembershipAttrName)) {
                String[] members;
                for (String item : members = ((DirContextAdapter)ctx).getStringAttributes(this.groupMembershipAttrName)) {
                    LdapName ldapName = LdapUtils.newLdapName((String)item);
                    LdapName memberRdn = LdapUtils.removeFirst((Name)ldapName, (Name)LdapUtils.newLdapName((String)this.base));
                    if (keyword != null) {
                        String rdnValue = LdapUtils.getValue((Name)memberRdn, (String)this.rdnKey).toString();
                        if (!rdnValue.toLowerCase().contains(keyword.toLowerCase())) continue;
                        UserInfo userInfo = this.lookupUser(memberRdn.toString(), userIds);
                        userInfos.add(userInfo);
                        continue;
                    }
                    UserInfo userInfo = this.lookupUser(memberRdn.toString(), userIds);
                    if (userInfo == null) continue;
                    userInfos.add(userInfo);
                }
                return userInfos;
            }
            HashSet memberUids = Sets.newHashSet((Object[])((DirContextAdapter)ctx).getStringAttributes(this.groupMembershipAttrName));
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                memberUids = Sets.intersection((Set)memberUids, (Set)Sets.newHashSet((Iterable)userIds));
            }
            for (String memberUid : memberUids) {
                UserInfo userInfo = this.searchUserById(memberUid);
                if (userInfo == null) continue;
                if (keyword != null) {
                    if (!userInfo.getUserId().toLowerCase().contains(keyword.toLowerCase())) continue;
                    userInfos.add(userInfo);
                    continue;
                }
                userInfos.add(userInfo);
            }
            return userInfos;
        });
    }

    @Override
    public List<UserInfo> searchUsers(String keyword, int offset, int limit) {
        List<UserInfo> users = new ArrayList<UserInfo>();
        if (StringUtils.isNotBlank((String)this.groupSearch)) {
            List<UserInfo> userListByGroup = this.searchUserInfoByGroup(this.groupBase, this.groupSearch, keyword, null);
            users.addAll(userListByGroup);
            return users.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet((o1, o2) -> {
                if (o1.getUserId().equals(o2.getUserId())) {
                    return 0;
                }
                return -1;
            })), ArrayList::new));
        }
        ContainerCriteria criteria = this.ldapQueryCriteria();
        if (!Strings.isNullOrEmpty((String)keyword)) {
            criteria.and(LdapQueryBuilder.query().where(this.loginIdAttrName).like(keyword + "*").or(this.userDisplayNameAttrName).like(keyword + "*"));
        }
        users = this.ldapTemplate.search((LdapQuery)criteria, this.ldapUserInfoMapper);
        return users;
    }

    @Override
    public UserInfo findByUserId(String userId) {
        if (StringUtils.isNotBlank((String)this.groupSearch)) {
            List<UserInfo> lists = this.searchUserInfoByGroup(this.groupBase, this.groupSearch, null, Collections.singletonList(userId));
            if (lists != null && !lists.isEmpty() && lists.get(0) != null) {
                return lists.get(0);
            }
            return null;
        }
        return (UserInfo)this.ldapTemplate.searchForObject((LdapQuery)this.ldapQueryCriteria().and(this.loginIdAttrName).is(userId), this.ldapUserInfoMapper);
    }

    @Override
    public List<UserInfo> findByUserIds(List<String> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((String)this.groupSearch)) {
            List<UserInfo> userListByGroup = this.searchUserInfoByGroup(this.groupBase, this.groupSearch, null, userIds);
            return userListByGroup;
        }
        ContainerCriteria criteria = LdapQueryBuilder.query().where(this.loginIdAttrName).is(userIds.get(0));
        userIds.stream().skip(1L).forEach(userId -> criteria.or(this.loginIdAttrName).is(userId));
        return this.ldapTemplate.search((LdapQuery)this.ldapQueryCriteria().and(criteria), this.ldapUserInfoMapper);
    }
}

