/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ldap;

import javax.naming.Name;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;

public class FilterLdapByGroupUserSearch
extends FilterBasedLdapUserSearch {
    private static final Logger logger = LoggerFactory.getLogger(FilterLdapByGroupUserSearch.class);
    private static final String MEMBER_UID_ATTR_NAME = "memberUid";
    private String searchBase;
    private String groupBase;
    private String groupSearch;
    private String rdnKey;
    private String groupMembershipAttrName;
    private String loginIdAttrName;
    private final SearchControls searchControls = new SearchControls();
    private BaseLdapPathContextSource contextSource;

    public FilterLdapByGroupUserSearch(String searchBase, String searchFilter, String groupBase, BaseLdapPathContextSource contextSource, String groupSearch, String rdnKey, String groupMembershipAttrName, String loginIdAttrName) {
        super(searchBase, searchFilter, contextSource);
        this.searchBase = searchBase;
        this.groupBase = groupBase;
        this.groupSearch = groupSearch;
        this.contextSource = contextSource;
        this.rdnKey = rdnKey;
        this.groupMembershipAttrName = groupMembershipAttrName;
        this.loginIdAttrName = loginIdAttrName;
    }

    private Name searchUserById(String userId) {
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate((ContextSource)this.contextSource);
        template.setSearchControls(this.searchControls);
        return (Name)template.searchForObject((LdapQuery)LdapQueryBuilder.query().where(this.loginIdAttrName).is(userId), ctx -> ((DirContextAdapter)ctx).getDn());
    }

    public DirContextOperations searchForUser(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug("Searching for user '" + username + "', with user search " + (Object)((Object)this));
        }
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate((ContextSource)this.contextSource);
        template.setSearchControls(this.searchControls);
        return (DirContextOperations)template.searchForObject(this.groupBase, this.groupSearch, ctx -> {
            String[] memberUids;
            if (!MEMBER_UID_ATTR_NAME.equals(this.groupMembershipAttrName)) {
                String[] members;
                for (String item : members = ((DirContextAdapter)ctx).getStringAttributes(this.groupMembershipAttrName)) {
                    LdapName memberDn = LdapUtils.newLdapName((String)item);
                    LdapName memberRdn = LdapUtils.removeFirst((Name)memberDn, (Name)LdapUtils.newLdapName((String)this.searchBase));
                    String rdnValue = LdapUtils.getValue((Name)memberRdn, (String)this.rdnKey).toString();
                    if (!rdnValue.equalsIgnoreCase(username)) continue;
                    return new DirContextAdapter(memberRdn.toString());
                }
                throw new UsernameNotFoundException("User " + username + " not found in directory.");
            }
            for (String memberUid : memberUids = ((DirContextAdapter)ctx).getStringAttributes(this.groupMembershipAttrName)) {
                if (!memberUid.equalsIgnoreCase(username)) continue;
                Name name = this.searchUserById(memberUid);
                LdapName ldapName = LdapUtils.newLdapName((Name)name);
                LdapName ldapRdn = LdapUtils.removeFirst((Name)ldapName, (Name)LdapUtils.newLdapName((String)this.searchBase));
                return new DirContextAdapter((Name)ldapRdn);
            }
            throw new UsernameNotFoundException("User " + username + " not found in directory.");
        });
    }
}

