/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.defaultimpl;

import com.ctrip.framework.apollo.openapi.repository.ConsumerRoleRepository;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.po.Permission;
import com.ctrip.framework.apollo.portal.entity.po.Role;
import com.ctrip.framework.apollo.portal.entity.po.RolePermission;
import com.ctrip.framework.apollo.portal.entity.po.UserRole;
import com.ctrip.framework.apollo.portal.repository.PermissionRepository;
import com.ctrip.framework.apollo.portal.repository.RolePermissionRepository;
import com.ctrip.framework.apollo.portal.repository.RoleRepository;
import com.ctrip.framework.apollo.portal.repository.UserRoleRepository;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class DefaultRolePermissionService
implements RolePermissionService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RolePermissionRepository rolePermissionRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private PortalConfig portalConfig;
    @Autowired
    private ConsumerRoleRepository consumerRoleRepository;

    @Override
    @Transactional
    public Role createRoleWithPermissions(Role role, Set<Long> permissionIds) {
        Role current = this.findRoleByRoleName(role.getRoleName());
        Preconditions.checkState((current == null ? 1 : 0) != 0, (String)"Role %s already exists!", (Object[])new Object[]{role.getRoleName()});
        Role createdRole = (Role)((Object)this.roleRepository.save((Object)role));
        if (!CollectionUtils.isEmpty(permissionIds)) {
            Iterable rolePermissions = permissionIds.stream().map(permissionId -> {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setRoleId(createdRole.getId());
                rolePermission.setPermissionId((long)permissionId);
                rolePermission.setDataChangeCreatedBy(createdRole.getDataChangeCreatedBy());
                rolePermission.setDataChangeLastModifiedBy(createdRole.getDataChangeLastModifiedBy());
                return rolePermission;
            }).collect(Collectors.toList());
            this.rolePermissionRepository.saveAll(rolePermissions);
        }
        return createdRole;
    }

    @Override
    @Transactional
    public Set<String> assignRoleToUsers(String roleName, Set<String> userIds, String operatorUserId) {
        Role role = this.findRoleByRoleName(roleName);
        Preconditions.checkState((role != null ? 1 : 0) != 0, (String)"Role %s doesn't exist!", (Object[])new Object[]{roleName});
        List<UserRole> existedUserRoles = this.userRoleRepository.findByUserIdInAndRoleId(userIds, role.getId());
        Set existedUserIds = existedUserRoles.stream().map(UserRole::getUserId).collect(Collectors.toSet());
        Sets.SetView toAssignUserIds = Sets.difference(userIds, existedUserIds);
        Iterable toCreate = toAssignUserIds.stream().map(userId -> {
            UserRole userRole = new UserRole();
            userRole.setRoleId(role.getId());
            userRole.setUserId((String)userId);
            userRole.setDataChangeCreatedBy(operatorUserId);
            userRole.setDataChangeLastModifiedBy(operatorUserId);
            return userRole;
        }).collect(Collectors.toList());
        this.userRoleRepository.saveAll(toCreate);
        return toAssignUserIds;
    }

    @Override
    @Transactional
    public void removeRoleFromUsers(String roleName, Set<String> userIds, String operatorUserId) {
        Role role = this.findRoleByRoleName(roleName);
        Preconditions.checkState((role != null ? 1 : 0) != 0, (String)"Role %s doesn't exist!", (Object[])new Object[]{roleName});
        List<UserRole> existedUserRoles = this.userRoleRepository.findByUserIdInAndRoleId(userIds, role.getId());
        for (UserRole userRole : existedUserRoles) {
            userRole.setDeleted(true);
            userRole.setDataChangeLastModifiedTime(new Date());
            userRole.setDataChangeLastModifiedBy(operatorUserId);
        }
        this.userRoleRepository.saveAll(existedUserRoles);
    }

    @Override
    public Set<UserInfo> queryUsersWithRole(String roleName) {
        Role role = this.findRoleByRoleName(roleName);
        if (role == null) {
            return Collections.emptySet();
        }
        List<UserRole> userRoles = this.userRoleRepository.findByRoleId(role.getId());
        Set<UserInfo> users = userRoles.stream().map(userRole -> {
            UserInfo userInfo = new UserInfo();
            userInfo.setUserId(userRole.getUserId());
            return userInfo;
        }).collect(Collectors.toSet());
        return users;
    }

    @Override
    public Role findRoleByRoleName(String roleName) {
        return this.roleRepository.findTopByRoleName(roleName);
    }

    @Override
    public boolean userHasPermission(String userId, String permissionType, String targetId) {
        Permission permission = this.permissionRepository.findTopByPermissionTypeAndTargetId(permissionType, targetId);
        if (permission == null) {
            return false;
        }
        if (this.isSuperAdmin(userId)) {
            return true;
        }
        List<UserRole> userRoles = this.userRoleRepository.findByUserId(userId);
        if (CollectionUtils.isEmpty(userRoles)) {
            return false;
        }
        Set<Long> roleIds = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toSet());
        List<RolePermission> rolePermissions = this.rolePermissionRepository.findByRoleIdIn(roleIds);
        if (CollectionUtils.isEmpty(rolePermissions)) {
            return false;
        }
        for (RolePermission rolePermission : rolePermissions) {
            if (rolePermission.getPermissionId() != permission.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Role> findUserRoles(String userId) {
        List<UserRole> userRoles = this.userRoleRepository.findByUserId(userId);
        if (CollectionUtils.isEmpty(userRoles)) {
            return Collections.emptyList();
        }
        Set roleIds = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toSet());
        return Lists.newLinkedList((Iterable)this.roleRepository.findAllById(roleIds));
    }

    @Override
    public boolean isSuperAdmin(String userId) {
        return this.portalConfig.superAdmins().contains(userId);
    }

    @Override
    @Transactional
    public Permission createPermission(Permission permission) {
        String targetId;
        String permissionType = permission.getPermissionType();
        Permission current = this.permissionRepository.findTopByPermissionTypeAndTargetId(permissionType, targetId = permission.getTargetId());
        Preconditions.checkState((current == null ? 1 : 0) != 0, (String)"Permission with permissionType %s targetId %s already exists!", (Object[])new Object[]{permissionType, targetId});
        return (Permission)((Object)this.permissionRepository.save((Object)permission));
    }

    @Override
    @Transactional
    public Set<Permission> createPermissions(Set<Permission> permissions) {
        HashMultimap targetIdPermissionTypes = HashMultimap.create();
        for (Permission permission : permissions) {
            targetIdPermissionTypes.put((Object)permission.getTargetId(), (Object)permission.getPermissionType());
        }
        for (String targetId : targetIdPermissionTypes.keySet()) {
            Collection permissionTypes = targetIdPermissionTypes.get((Object)targetId);
            List<Permission> current = this.permissionRepository.findByPermissionTypeInAndTargetId(permissionTypes, targetId);
            Preconditions.checkState((boolean)CollectionUtils.isEmpty(current), (String)"Permission with permissionType %s targetId %s already exists!", (Object[])new Object[]{permissionTypes, targetId});
        }
        Iterable results = this.permissionRepository.saveAll(permissions);
        return StreamSupport.stream(results.spliterator(), false).collect(Collectors.toSet());
    }

    @Override
    @Transactional
    public void deleteRolePermissionsByAppId(String appId, String operator) {
        List<Long> roleIds;
        List<Long> permissionIds = this.permissionRepository.findPermissionIdsByAppId(appId);
        if (!permissionIds.isEmpty()) {
            this.permissionRepository.batchDelete(permissionIds, operator);
            this.rolePermissionRepository.batchDeleteByPermissionIds(permissionIds, operator);
        }
        if (!(roleIds = this.roleRepository.findRoleIdsByAppId(appId)).isEmpty()) {
            this.roleRepository.batchDelete(roleIds, operator);
            this.userRoleRepository.batchDeleteByRoleIds(roleIds, operator);
            this.consumerRoleRepository.batchDeleteByRoleIds(roleIds, operator);
        }
    }

    @Override
    @Transactional
    public void deleteRolePermissionsByAppIdAndNamespace(String appId, String namespaceName, String operator) {
        List<Long> roleIds;
        List<Long> permissionIds = this.permissionRepository.findPermissionIdsByAppIdAndNamespace(appId, namespaceName);
        if (!permissionIds.isEmpty()) {
            this.permissionRepository.batchDelete(permissionIds, operator);
            this.rolePermissionRepository.batchDeleteByPermissionIds(permissionIds, operator);
        }
        if (!(roleIds = this.roleRepository.findRoleIdsByAppIdAndNamespace(appId, namespaceName)).isEmpty()) {
            this.roleRepository.batchDelete(roleIds, operator);
            this.userRoleRepository.batchDeleteByRoleIds(roleIds, operator);
            this.consumerRoleRepository.batchDeleteByRoleIds(roleIds, operator);
        }
    }
}

