/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.defaultimpl;

import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.entity.BaseEntity;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.po.Permission;
import com.ctrip.framework.apollo.portal.entity.po.Role;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.repository.PermissionRepository;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.service.SystemRoleManagerService;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultRoleInitializationService
implements RoleInitializationService {
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private PortalConfig portalConfig;
    @Autowired
    private PermissionRepository permissionRepository;

    @Override
    @Transactional
    public void initAppRoles(App app) {
        String appId = app.getAppId();
        String appMasterRoleName = RoleUtils.buildAppMasterRoleName(appId);
        if (this.rolePermissionService.findRoleByRoleName(appMasterRoleName) != null) {
            return;
        }
        String operator = app.getDataChangeCreatedBy();
        this.createAppMasterRole(appId, operator);
        this.createManageAppMasterRole(appId, operator);
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildAppMasterRoleName(appId), Sets.newHashSet((Object[])new String[]{app.getOwnerName()}), operator);
        this.initNamespaceRoles(appId, "application", operator);
        this.initNamespaceEnvRoles(appId, "application", operator);
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, "application", "ModifyNamespace"), Sets.newHashSet((Object[])new String[]{operator}), operator);
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, "application", "ReleaseNamespace"), Sets.newHashSet((Object[])new String[]{operator}), operator);
    }

    @Override
    @Transactional
    public void initNamespaceRoles(String appId, String namespaceName, String operator) {
        String releaseNamespaceRoleName;
        String modifyNamespaceRoleName = RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName);
        if (this.rolePermissionService.findRoleByRoleName(modifyNamespaceRoleName) == null) {
            this.createNamespaceRole(appId, namespaceName, "ModifyNamespace", modifyNamespaceRoleName, operator);
        }
        if (this.rolePermissionService.findRoleByRoleName(releaseNamespaceRoleName = RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName)) == null) {
            this.createNamespaceRole(appId, namespaceName, "ReleaseNamespace", releaseNamespaceRoleName, operator);
        }
    }

    @Override
    @Transactional
    public void initNamespaceEnvRoles(String appId, String namespaceName, String operator) {
        List<Env> portalEnvs = this.portalConfig.portalSupportedEnvs();
        for (Env env : portalEnvs) {
            this.initNamespaceSpecificEnvRoles(appId, namespaceName, env.toString(), operator);
        }
    }

    @Override
    @Transactional
    public void initNamespaceSpecificEnvRoles(String appId, String namespaceName, String env, String operator) {
        String releaseNamespaceEnvRoleName;
        String modifyNamespaceEnvRoleName = RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName, env);
        if (this.rolePermissionService.findRoleByRoleName(modifyNamespaceEnvRoleName) == null) {
            this.createNamespaceEnvRole(appId, namespaceName, "ModifyNamespace", env, modifyNamespaceEnvRoleName, operator);
        }
        if (this.rolePermissionService.findRoleByRoleName(releaseNamespaceEnvRoleName = RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName, env)) == null) {
            this.createNamespaceEnvRole(appId, namespaceName, "ReleaseNamespace", env, releaseNamespaceEnvRoleName, operator);
        }
    }

    @Override
    @Transactional
    public void initCreateAppRole() {
        if (this.rolePermissionService.findRoleByRoleName(SystemRoleManagerService.CREATE_APPLICATION_ROLE_NAME) != null) {
            return;
        }
        Permission createAppPermission = this.permissionRepository.findTopByPermissionTypeAndTargetId("CreateApplication", "SystemRole");
        if (createAppPermission == null) {
            createAppPermission = this.createPermission("SystemRole", "CreateApplication", "apollo");
            this.rolePermissionService.createPermission(createAppPermission);
        }
        Role createAppRole = this.createRole(SystemRoleManagerService.CREATE_APPLICATION_ROLE_NAME, "apollo");
        this.rolePermissionService.createRoleWithPermissions(createAppRole, Sets.newHashSet((Object[])new Long[]{createAppPermission.getId()}));
    }

    @Transactional
    private void createManageAppMasterRole(String appId, String operator) {
        Permission permission = this.createPermission(appId, "ManageAppMaster", operator);
        this.rolePermissionService.createPermission(permission);
        Role role = this.createRole(RoleUtils.buildAppRoleName(appId, "ManageAppMaster"), operator);
        HashSet<Long> permissionIds = new HashSet<Long>();
        permissionIds.add(permission.getId());
        this.rolePermissionService.createRoleWithPermissions(role, permissionIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void initManageAppMasterRole(String appId, String operator) {
        String manageAppMasterRoleName = RoleUtils.buildAppRoleName(appId, "ManageAppMaster");
        if (this.rolePermissionService.findRoleByRoleName(manageAppMasterRoleName) != null) {
            return;
        }
        Class<DefaultRoleInitializationService> clazz = DefaultRoleInitializationService.class;
        synchronized (DefaultRoleInitializationService.class) {
            this.createManageAppMasterRole(appId, operator);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void createAppMasterRole(String appId, String operator) {
        Set<Permission> appPermissions = Stream.of("CreateCluster", "CreateNamespace", "AssignRole").map(permissionType -> this.createPermission(appId, (String)permissionType, operator)).collect(Collectors.toSet());
        Set<Permission> createdAppPermissions = this.rolePermissionService.createPermissions(appPermissions);
        Set<Long> appPermissionIds = createdAppPermissions.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        Role appMasterRole = this.createRole(RoleUtils.buildAppMasterRoleName(appId), operator);
        this.rolePermissionService.createRoleWithPermissions(appMasterRole, appPermissionIds);
    }

    private Permission createPermission(String targetId, String permissionType, String operator) {
        Permission permission = new Permission();
        permission.setPermissionType(permissionType);
        permission.setTargetId(targetId);
        permission.setDataChangeCreatedBy(operator);
        permission.setDataChangeLastModifiedBy(operator);
        return permission;
    }

    private Role createRole(String roleName, String operator) {
        Role role = new Role();
        role.setRoleName(roleName);
        role.setDataChangeCreatedBy(operator);
        role.setDataChangeLastModifiedBy(operator);
        return role;
    }

    private void createNamespaceRole(String appId, String namespaceName, String permissionType, String roleName, String operator) {
        Permission permission = this.createPermission(RoleUtils.buildNamespaceTargetId(appId, namespaceName), permissionType, operator);
        Permission createdPermission = this.rolePermissionService.createPermission(permission);
        Role role = this.createRole(roleName, operator);
        this.rolePermissionService.createRoleWithPermissions(role, Sets.newHashSet((Object[])new Long[]{createdPermission.getId()}));
    }

    private void createNamespaceEnvRole(String appId, String namespaceName, String permissionType, String env, String roleName, String operator) {
        Permission permission = this.createPermission(RoleUtils.buildNamespaceTargetId(appId, namespaceName, env), permissionType, operator);
        Permission createdPermission = this.rolePermissionService.createPermission(permission);
        Role role = this.createRole(roleName, operator);
        this.rolePermissionService.createRoleWithPermissions(role, Sets.newHashSet((Object[])new Long[]{createdPermission.getId()}));
    }
}

