/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ctrip.filters;

import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class UserAccessFilter
implements Filter {
    private static final String STATIC_RESOURCE_REGEX = ".*\\.(js|html|htm|png|css|woff2)$";
    private UserInfoHolder userInfoHolder;

    public UserAccessFilter(UserInfoHolder userInfoHolder) {
        this.userInfoHolder = userInfoHolder;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUri = ((HttpServletRequest)request).getRequestURI();
        try {
            UserInfo userInfo;
            if (!this.isOpenAPIRequest(requestUri) && !this.isStaticResource(requestUri) && (userInfo = this.userInfoHolder.getUser()) != null) {
                Tracer.logEvent((String)"User.Access", (String)userInfo.getUserId());
            }
        }
        catch (Throwable e) {
            Tracer.logError((String)"Record user access info error.", (Throwable)e);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean isOpenAPIRequest(String uri) {
        return !Strings.isNullOrEmpty((String)uri) && uri.startsWith("/openapi");
    }

    private boolean isStaticResource(String uri) {
        return !Strings.isNullOrEmpty((String)uri) && uri.matches(STATIC_RESOURCE_REGEX);
    }
}

