/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ctrip;

import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.ctrip.filters.UserAccessFilter;
import com.google.common.base.Strings;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"ctrip"})
public class WebContextConfiguration {
    private final PortalConfig portalConfig;
    private final UserInfoHolder userInfoHolder;

    public WebContextConfiguration(PortalConfig portalConfig, UserInfoHolder userInfoHolder) {
        this.portalConfig = portalConfig;
        this.userInfoHolder = userInfoHolder;
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            String loggingServerIP = this.portalConfig.cloggingUrl();
            String loggingServerPort = this.portalConfig.cloggingPort();
            String credisServiceUrl = this.portalConfig.credisServiceUrl();
            servletContext.setInitParameter("loggingServerIP", Strings.isNullOrEmpty((String)loggingServerIP) ? "" : loggingServerIP);
            servletContext.setInitParameter("loggingServerPort", Strings.isNullOrEmpty((String)loggingServerPort) ? "" : loggingServerPort);
            servletContext.setInitParameter("credisServiceUrl", Strings.isNullOrEmpty((String)credisServiceUrl) ? "" : credisServiceUrl);
        };
    }

    @Bean
    public FilterRegistrationBean userAccessFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new UserAccessFilter(this.userInfoHolder));
        filter.addUrlPatterns(new String[]{"/*"});
        return filter;
    }
}

