/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ctrip;

import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class CtripUserService
implements UserService {
    private RestTemplate restTemplate;
    private List<String> searchUserMatchFields;
    private ParameterizedTypeReference<Map<String, List<UserServiceResponse>>> responseType;
    private PortalConfig portalConfig;

    public CtripUserService(PortalConfig portalConfig) {
        this.portalConfig = portalConfig;
        this.restTemplate = new RestTemplate(this.clientHttpRequestFactory());
        this.searchUserMatchFields = Lists.newArrayList((Object[])new String[]{"empcode", "empaccount", "displayname", "c_name", "pinyin"});
        this.responseType = new ParameterizedTypeReference<Map<String, List<UserServiceResponse>>>(){};
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(this.portalConfig.connectTimeout());
        factory.setReadTimeout(this.portalConfig.readTimeout());
        return factory;
    }

    @Override
    public List<UserInfo> searchUsers(String keyword, int offset, int limit) {
        UserServiceRequest request = this.assembleSearchUserRequest(keyword, offset, limit);
        HttpEntity entity = new HttpEntity((Object)request);
        ResponseEntity response = this.restTemplate.exchange(this.portalConfig.userServiceUrl(), HttpMethod.POST, entity, this.responseType, new Object[0]);
        if (!((Map)response.getBody()).containsKey("result")) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(((List)((Map)response.getBody()).get("result")).stream().map(this::transformUserServiceResponseToUserInfo).collect(Collectors.toList()));
        return result;
    }

    @Override
    public UserInfo findByUserId(String userId) {
        List<UserInfo> userInfoList = this.findByUserIds(Lists.newArrayList((Object[])new String[]{userId}));
        if (CollectionUtils.isEmpty(userInfoList)) {
            return null;
        }
        return userInfoList.get(0);
    }

    @Override
    public List<UserInfo> findByUserIds(List<String> userIds) {
        UserServiceRequest request = this.assembleFindUserRequest(Lists.newArrayList(userIds));
        HttpEntity entity = new HttpEntity((Object)request);
        ResponseEntity response = this.restTemplate.exchange(this.portalConfig.userServiceUrl(), HttpMethod.POST, entity, this.responseType, new Object[0]);
        if (!((Map)response.getBody()).containsKey("result")) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(((List)((Map)response.getBody()).get("result")).stream().map(this::transformUserServiceResponseToUserInfo).collect(Collectors.toList()));
        return result;
    }

    private UserInfo transformUserServiceResponseToUserInfo(UserServiceResponse userServiceResponse) {
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(userServiceResponse.getEmpaccount());
        userInfo.setName(userServiceResponse.getDisplayname());
        userInfo.setEmail(userServiceResponse.getEmail());
        return userInfo;
    }

    UserServiceRequest assembleSearchUserRequest(String keyword, int offset, int limit) {
        HashMap query = Maps.newHashMap();
        HashMap multiMatchMap = Maps.newHashMap();
        multiMatchMap.put("fields", this.searchUserMatchFields);
        multiMatchMap.put("operator", "and");
        multiMatchMap.put("query", keyword);
        multiMatchMap.put("type", "best_fields");
        query.put("multi_match", multiMatchMap);
        return this.assembleUserServiceRequest(query, offset, limit);
    }

    UserServiceRequest assembleFindUserRequest(List<String> userIds) {
        ImmutableMap query = ImmutableMap.of((Object)"filtered", (Object)ImmutableMap.of((Object)"filter", (Object)ImmutableMap.of((Object)"terms", (Object)ImmutableMap.of((Object)"empaccount", userIds))));
        return this.assembleUserServiceRequest((Map<String, Object>)query, 0, userIds.size());
    }

    private UserServiceRequest assembleUserServiceRequest(Map<String, Object> query, int offset, int limit) {
        UserServiceRequest request = new UserServiceRequest();
        request.setAccess_token(this.portalConfig.userServiceAccessToken());
        UserServiceRequestBody requestBody = new UserServiceRequestBody();
        requestBody.setIndexAlias("itdb_emloyee");
        requestBody.setType("emloyee");
        request.setRequest_body(requestBody);
        HashMap queryJson = Maps.newHashMap();
        requestBody.setQueryJson(queryJson);
        queryJson.put("query", query);
        queryJson.put("from", offset);
        queryJson.put("size", limit);
        return request;
    }

    static class UserServiceResponse {
        private String empaccount;
        private String displayname;
        private String email;

        UserServiceResponse() {
        }

        public String getEmpaccount() {
            return this.empaccount;
        }

        public void setEmpaccount(String empaccount) {
            this.empaccount = empaccount;
        }

        public String getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(String displayname) {
            this.displayname = displayname;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    static class UserServiceRequestBody {
        private String indexAlias;
        private String type;
        private Map<String, Object> queryJson;

        UserServiceRequestBody() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getIndexAlias() {
            return this.indexAlias;
        }

        public void setIndexAlias(String indexAlias) {
            this.indexAlias = indexAlias;
        }

        public Map<String, Object> getQueryJson() {
            return this.queryJson;
        }

        public void setQueryJson(Map<String, Object> queryJson) {
            this.queryJson = queryJson;
        }
    }

    static class UserServiceRequest {
        private String access_token;
        private UserServiceRequestBody request_body;

        UserServiceRequest() {
        }

        public String getAccess_token() {
            return this.access_token;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public UserServiceRequestBody getRequest_body() {
            return this.request_body;
        }

        public void setRequest_body(UserServiceRequestBody request_body) {
            this.request_body = request_body;
        }
    }
}

