/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.ctrip;

import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.ReleaseHistoryBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.AppService;
import com.ctrip.framework.apollo.portal.service.ReleaseService;
import com.ctrip.framework.apollo.portal.spi.MQService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.gson.Gson;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CtripMQService
implements MQService {
    private static final FastDateFormat TIMESTAMP_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd hh:mm:ss");
    private static final String CONFIG_PUBLISH_NOTIFY_TO_NOC_TOPIC = "ops.noc.record.created";
    private Gson gson = new Gson();
    @Autowired
    private AppService appService;
    @Autowired
    private ReleaseService releaseService;
    @Autowired
    private PortalConfig portalConfig;
    private RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        this.restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory rf = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        rf.setReadTimeout(this.portalConfig.readTimeout());
        rf.setConnectTimeout(this.portalConfig.connectTimeout());
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON_UTF8, MediaType.APPLICATION_OCTET_STREAM));
        this.restTemplate.setMessageConverters(Arrays.asList(converter, new FormHttpMessageConverter()));
    }

    @Override
    public void sendPublishMsg(Env env, ReleaseHistoryBO releaseHistory) {
        if (releaseHistory == null) {
            return;
        }
        PublishMsg msg = this.buildPublishMsg(env, releaseHistory);
        this.sendMsg(this.portalConfig.hermesServerAddress(), CONFIG_PUBLISH_NOTIFY_TO_NOC_TOPIC, msg);
    }

    private PublishMsg buildPublishMsg(Env env, ReleaseHistoryBO releaseHistory) {
        PublishMsg msg = new PublishMsg();
        msg.setPriority("\u4e2d");
        msg.setTool_origin("Apollo");
        String appId = releaseHistory.getAppId();
        App app = this.appService.load(appId);
        msg.setInfluence_bu(app.getOrgName());
        msg.setAppid(appId);
        msg.setAssginee(releaseHistory.getOperator());
        msg.setOperation_time(TIMESTAMP_FORMAT.format(releaseHistory.getReleaseTime()));
        msg.setDesc(this.gson.toJson((Object)this.releaseService.compare(env, releaseHistory.getPreviousReleaseId(), releaseHistory.getReleaseId())));
        return msg;
    }

    private void sendMsg(String serverAddress, String topic, Object msg) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)(MediaType.APPLICATION_OCTET_STREAM + ";charset=UTF-8")));
        HttpEntity request = new HttpEntity(msg, (MultiValueMap)headers);
        try {
            this.restTemplate.postForObject(serverAddress + "/topics/" + topic, (Object)request, Object.class, new Object[0]);
        }
        catch (Exception e) {
            Tracer.logError((String)"Send publish msg to hermes failed", (Throwable)e);
        }
    }

    private static class PublishMsg {
        private String assginee;
        private String desc;
        private String operation_time;
        private String tool_origin;
        private String priority;
        private String influence_bu;
        private String appid;

        private PublishMsg() {
        }

        public String getAssginee() {
            return this.assginee;
        }

        public void setAssginee(String assginee) {
            this.assginee = assginee;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getOperation_time() {
            return this.operation_time;
        }

        public void setOperation_time(String operation_time) {
            this.operation_time = operation_time;
        }

        public String getTool_origin() {
            return this.tool_origin;
        }

        public void setTool_origin(String tool_origin) {
            this.tool_origin = tool_origin;
        }

        public String getPriority() {
            return this.priority;
        }

        public void setPriority(String priority) {
            this.priority = priority;
        }

        public String getInfluence_bu() {
            return this.influence_bu;
        }

        public void setInfluence_bu(String influence_bu) {
            this.influence_bu = influence_bu;
        }

        public String getAppid() {
            return this.appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }
    }
}

