/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.spi.configuration;

import com.ctrip.framework.apollo.common.condition.ConditionalOnMissingProfile;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.spi.LogoutHandler;
import com.ctrip.framework.apollo.portal.spi.SsoHeartbeatHandler;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.spi.configuration.LdapExtendProperties;
import com.ctrip.framework.apollo.portal.spi.configuration.LdapProperties;
import com.ctrip.framework.apollo.portal.spi.ctrip.CtripLogoutHandler;
import com.ctrip.framework.apollo.portal.spi.ctrip.CtripSsoHeartbeatHandler;
import com.ctrip.framework.apollo.portal.spi.ctrip.CtripUserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.ctrip.CtripUserService;
import com.ctrip.framework.apollo.portal.spi.defaultimpl.DefaultLogoutHandler;
import com.ctrip.framework.apollo.portal.spi.defaultimpl.DefaultSsoHeartbeatHandler;
import com.ctrip.framework.apollo.portal.spi.defaultimpl.DefaultUserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.defaultimpl.DefaultUserService;
import com.ctrip.framework.apollo.portal.spi.ldap.ApolloLdapAuthenticationProvider;
import com.ctrip.framework.apollo.portal.spi.ldap.FilterLdapByGroupUserSearch;
import com.ctrip.framework.apollo.portal.spi.ldap.LdapUserService;
import com.ctrip.framework.apollo.portal.spi.springsecurity.SpringSecurityUserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.springsecurity.SpringSecurityUserService;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

@Configuration
public class AuthConfiguration {
    private static final String[] BY_PASS_URLS = new String[]{"/prometheus/**", "/metrics/**", "/openapi/**", "/vendor/**", "/styles/**", "/scripts/**", "/views/**", "/img/**", "/i18n/**", "/prefix-path", "/health"};

    @ConditionalOnMissingProfile(value={"auth", "ldap"})
    @Configuration
    @EnableWebSecurity
    @EnableGlobalMethodSecurity(prePostEnabled=true)
    static class DefaultWebSecurityConfig
    extends WebSecurityConfigurerAdapter {
        DefaultWebSecurityConfig() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            http.csrf().disable();
            http.headers().frameOptions().sameOrigin();
        }
    }

    @Configuration
    @ConditionalOnMissingProfile(value={"ctrip", "auth", "ldap"})
    static class DefaultAuthAutoConfiguration {
        DefaultAuthAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SsoHeartbeatHandler.class})
        public SsoHeartbeatHandler defaultSsoHeartbeatHandler() {
            return new DefaultSsoHeartbeatHandler();
        }

        @Bean
        @ConditionalOnMissingBean(value={UserInfoHolder.class})
        public DefaultUserInfoHolder defaultUserInfoHolder() {
            return new DefaultUserInfoHolder();
        }

        @Bean
        @ConditionalOnMissingBean(value={LogoutHandler.class})
        public DefaultLogoutHandler logoutHandler() {
            return new DefaultLogoutHandler();
        }

        @Bean
        @ConditionalOnMissingBean(value={UserService.class})
        public UserService defaultUserService() {
            return new DefaultUserService();
        }
    }

    @Order(value=99)
    @Profile(value={"ldap"})
    @Configuration
    @EnableWebSecurity
    @EnableGlobalMethodSecurity(prePostEnabled=true)
    static class SpringSecurityLDAPConfigurer
    extends WebSecurityConfigurerAdapter {
        private final LdapProperties ldapProperties;
        private final LdapContextSource ldapContextSource;
        private final LdapExtendProperties ldapExtendProperties;

        public SpringSecurityLDAPConfigurer(LdapProperties ldapProperties, LdapContextSource ldapContextSource, LdapExtendProperties ldapExtendProperties) {
            this.ldapProperties = ldapProperties;
            this.ldapContextSource = ldapContextSource;
            this.ldapExtendProperties = ldapExtendProperties;
        }

        @Bean
        public FilterBasedLdapUserSearch userSearch() {
            if (this.ldapExtendProperties.getGroup() == null || StringUtils.isBlank((String)this.ldapExtendProperties.getGroup().getGroupSearch())) {
                FilterBasedLdapUserSearch filterBasedLdapUserSearch = new FilterBasedLdapUserSearch("", this.ldapProperties.getSearchFilter(), (BaseLdapPathContextSource)this.ldapContextSource);
                filterBasedLdapUserSearch.setSearchSubtree(true);
                return filterBasedLdapUserSearch;
            }
            FilterLdapByGroupUserSearch filterLdapByGroupUserSearch = new FilterLdapByGroupUserSearch(this.ldapProperties.getBase(), this.ldapProperties.getSearchFilter(), this.ldapExtendProperties.getGroup().getGroupBase(), (BaseLdapPathContextSource)this.ldapContextSource, this.ldapExtendProperties.getGroup().getGroupSearch(), this.ldapExtendProperties.getMapping().getRdnKey(), this.ldapExtendProperties.getGroup().getGroupMembership(), this.ldapExtendProperties.getMapping().getLoginId());
            filterLdapByGroupUserSearch.setSearchSubtree(true);
            return filterLdapByGroupUserSearch;
        }

        @Bean
        public LdapAuthenticationProvider ldapAuthProvider() {
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)this.ldapContextSource);
            bindAuthenticator.setUserSearch((LdapUserSearch)this.userSearch());
            DefaultLdapAuthoritiesPopulator defaultAuthAutoConfiguration = new DefaultLdapAuthoritiesPopulator((ContextSource)this.ldapContextSource, null);
            defaultAuthAutoConfiguration.setIgnorePartialResultException(true);
            defaultAuthAutoConfiguration.setSearchSubtree(true);
            return new ApolloLdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)defaultAuthAutoConfiguration, this.ldapExtendProperties);
        }

        protected void configure(HttpSecurity http) throws Exception {
            http.csrf().disable();
            http.headers().frameOptions().sameOrigin();
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(BY_PASS_URLS)).permitAll().antMatchers(new String[]{"/**"})).authenticated();
            ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage("/signin").defaultSuccessUrl("/", true)).permitAll()).failureUrl("/signin?#/error")).and()).httpBasic();
            http.logout().logoutUrl("/user/logout").invalidateHttpSession(true).clearAuthentication(true).logoutSuccessUrl("/signin?#/logout");
            http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/signin"));
        }

        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            auth.authenticationProvider((AuthenticationProvider)this.ldapAuthProvider());
        }
    }

    @Configuration
    @Profile(value={"ldap"})
    @EnableConfigurationProperties(value={LdapProperties.class, LdapExtendProperties.class})
    static class SpringSecurityLDAPAuthAutoConfiguration {
        private final LdapProperties properties;
        private final Environment environment;

        public SpringSecurityLDAPAuthAutoConfiguration(LdapProperties properties, Environment environment) {
            this.properties = properties;
            this.environment = environment;
        }

        @Bean
        @ConditionalOnMissingBean(value={SsoHeartbeatHandler.class})
        public SsoHeartbeatHandler defaultSsoHeartbeatHandler() {
            return new DefaultSsoHeartbeatHandler();
        }

        @Bean
        @ConditionalOnMissingBean(value={UserInfoHolder.class})
        public UserInfoHolder springSecurityUserInfoHolder() {
            return new SpringSecurityUserInfoHolder();
        }

        @Bean
        @ConditionalOnMissingBean(value={LogoutHandler.class})
        public LogoutHandler logoutHandler() {
            return new DefaultLogoutHandler();
        }

        @Bean
        @ConditionalOnMissingBean(value={UserService.class})
        public UserService springSecurityUserService() {
            return new LdapUserService();
        }

        @Bean
        @ConditionalOnMissingBean
        public ContextSource ldapContextSource() {
            LdapContextSource source = new LdapContextSource();
            source.setUserDn(this.properties.getUsername());
            source.setPassword(this.properties.getPassword());
            source.setAnonymousReadOnly(this.properties.getAnonymousReadOnly());
            source.setBase(this.properties.getBase());
            source.setUrls(this.properties.determineUrls(this.environment));
            source.setBaseEnvironmentProperties(Collections.unmodifiableMap(this.properties.getBaseEnvironment()));
            return source;
        }

        @Bean
        @ConditionalOnMissingBean(value={LdapOperations.class})
        public LdapTemplate ldapTemplate(ContextSource contextSource) {
            LdapTemplate ldapTemplate = new LdapTemplate(contextSource);
            ldapTemplate.setIgnorePartialResultException(true);
            return ldapTemplate;
        }
    }

    @Order(value=99)
    @Profile(value={"auth"})
    @Configuration
    @EnableWebSecurity
    @EnableGlobalMethodSecurity(prePostEnabled=true)
    static class SpringSecurityConfigurer
    extends WebSecurityConfigurerAdapter {
        public static final String USER_ROLE = "user";

        SpringSecurityConfigurer() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            http.csrf().disable();
            http.headers().frameOptions().sameOrigin();
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(BY_PASS_URLS)).permitAll().antMatchers(new String[]{"/**"})).hasAnyRole(new String[]{USER_ROLE});
            ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage("/signin").defaultSuccessUrl("/", true)).permitAll()).failureUrl("/signin?#/error")).and()).httpBasic();
            http.logout().logoutUrl("/user/logout").invalidateHttpSession(true).clearAuthentication(true).logoutSuccessUrl("/signin?#/logout");
            http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/signin"));
        }
    }

    @Configuration
    @Profile(value={"auth"})
    static class SpringSecurityAuthAutoConfiguration {
        SpringSecurityAuthAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SsoHeartbeatHandler.class})
        public SsoHeartbeatHandler defaultSsoHeartbeatHandler() {
            return new DefaultSsoHeartbeatHandler();
        }

        @Bean
        @ConditionalOnMissingBean(value={UserInfoHolder.class})
        public UserInfoHolder springSecurityUserInfoHolder() {
            return new SpringSecurityUserInfoHolder();
        }

        @Bean
        @ConditionalOnMissingBean(value={LogoutHandler.class})
        public LogoutHandler logoutHandler() {
            return new DefaultLogoutHandler();
        }

        @Bean
        public JdbcUserDetailsManager jdbcUserDetailsManager(AuthenticationManagerBuilder auth, DataSource datasource) throws Exception {
            JdbcUserDetailsManager jdbcUserDetailsManager = ((JdbcUserDetailsManagerConfigurer)auth.jdbcAuthentication().passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder())).dataSource(datasource).usersByUsernameQuery("select Username,Password,Enabled from `Users` where Username = ?").authoritiesByUsernameQuery("select Username,Authority from `Authorities` where Username = ?").getUserDetailsService();
            jdbcUserDetailsManager.setUserExistsSql("select Username from `Users` where Username = ?");
            jdbcUserDetailsManager.setCreateUserSql("insert into `Users` (Username, Password, Enabled) values (?,?,?)");
            jdbcUserDetailsManager.setUpdateUserSql("update `Users` set Password = ?, Enabled = ? where id = (select u.id from (select id from `Users` where Username = ?) as u)");
            jdbcUserDetailsManager.setDeleteUserSql("delete from `Users` where id = (select u.id from (select id from `Users` where Username = ?) as u)");
            jdbcUserDetailsManager.setCreateAuthoritySql("insert into `Authorities` (Username, Authority) values (?,?)");
            jdbcUserDetailsManager.setDeleteUserAuthoritiesSql("delete from `Authorities` where id in (select a.id from (select id from `Authorities` where Username = ?) as a)");
            jdbcUserDetailsManager.setChangePasswordSql("update `Users` set Password = ? where id = (select u.id from (select id from `Users` where Username = ?) as u)");
            return jdbcUserDetailsManager;
        }

        @Bean
        @ConditionalOnMissingBean(value={UserService.class})
        public UserService springSecurityUserService() {
            return new SpringSecurityUserService();
        }
    }

    @Configuration
    @Profile(value={"ctrip"})
    static class CtripAuthAutoConfiguration {
        private final PortalConfig portalConfig;

        public CtripAuthAutoConfiguration(PortalConfig portalConfig) {
            this.portalConfig = portalConfig;
        }

        @Bean
        public ServletListenerRegistrationBean redisAppSettingListner() {
            ServletListenerRegistrationBean redisAppSettingListener = new ServletListenerRegistrationBean();
            redisAppSettingListener.setListener(this.listener("org.jasig.cas.client.credis.CRedisAppSettingListner"));
            return redisAppSettingListener;
        }

        @Bean
        public ServletListenerRegistrationBean singleSignOutHttpSessionListener() {
            ServletListenerRegistrationBean singleSignOutHttpSessionListener = new ServletListenerRegistrationBean();
            singleSignOutHttpSessionListener.setListener(this.listener("org.jasig.cas.client.session.SingleSignOutHttpSessionListener"));
            return singleSignOutHttpSessionListener;
        }

        @Bean
        public FilterRegistrationBean casFilter() {
            FilterRegistrationBean singleSignOutFilter = new FilterRegistrationBean();
            singleSignOutFilter.setFilter(this.filter("org.jasig.cas.client.session.SingleSignOutFilter"));
            singleSignOutFilter.addUrlPatterns(new String[]{"/*"});
            singleSignOutFilter.setOrder(1);
            return singleSignOutFilter;
        }

        @Bean
        public FilterRegistrationBean authenticationFilter() {
            FilterRegistrationBean casFilter = new FilterRegistrationBean();
            HashMap filterInitParam = Maps.newHashMap();
            filterInitParam.put("redisClusterName", "casClientPrincipal");
            filterInitParam.put("serverName", this.portalConfig.portalServerName());
            filterInitParam.put("casServerLoginUrl", this.portalConfig.casServerLoginUrl());
            filterInitParam.put("useSession", "false");
            filterInitParam.put("/openapi.*", "exclude");
            casFilter.setInitParameters((Map)filterInitParam);
            casFilter.setFilter(this.filter("com.ctrip.framework.apollo.sso.filter.ApolloAuthenticationFilter"));
            casFilter.addUrlPatterns(new String[]{"/*"});
            casFilter.setOrder(2);
            return casFilter;
        }

        @Bean
        public FilterRegistrationBean casValidationFilter() {
            FilterRegistrationBean casValidationFilter = new FilterRegistrationBean();
            HashMap filterInitParam = Maps.newHashMap();
            filterInitParam.put("casServerUrlPrefix", this.portalConfig.casServerUrlPrefix());
            filterInitParam.put("serverName", this.portalConfig.portalServerName());
            filterInitParam.put("encoding", "UTF-8");
            filterInitParam.put("useSession", "false");
            filterInitParam.put("useRedis", "true");
            filterInitParam.put("redisClusterName", "casClientPrincipal");
            casValidationFilter.setFilter(this.filter("org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter"));
            casValidationFilter.setInitParameters((Map)filterInitParam);
            casValidationFilter.addUrlPatterns(new String[]{"/*"});
            casValidationFilter.setOrder(3);
            return casValidationFilter;
        }

        @Bean
        public FilterRegistrationBean assertionHolder() {
            FilterRegistrationBean assertionHolderFilter = new FilterRegistrationBean();
            HashMap filterInitParam = Maps.newHashMap();
            filterInitParam.put("/openapi.*", "exclude");
            assertionHolderFilter.setInitParameters((Map)filterInitParam);
            assertionHolderFilter.setFilter(this.filter("com.ctrip.framework.apollo.sso.filter.ApolloAssertionThreadLocalFilter"));
            assertionHolderFilter.addUrlPatterns(new String[]{"/*"});
            assertionHolderFilter.setOrder(4);
            return assertionHolderFilter;
        }

        @Bean
        public CtripUserInfoHolder ctripUserInfoHolder() {
            return new CtripUserInfoHolder();
        }

        @Bean
        public CtripLogoutHandler logoutHandler() {
            return new CtripLogoutHandler();
        }

        private Filter filter(String className) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
                Object obj = clazz.newInstance();
                return (Filter)obj;
            }
            catch (Exception e) {
                throw new RuntimeException("instance filter fail", e);
            }
        }

        private EventListener listener(String className) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
                Object obj = clazz.newInstance();
                return (EventListener)obj;
            }
            catch (Exception e) {
                throw new RuntimeException("instance listener fail", e);
            }
        }

        @Bean
        public UserService ctripUserService(PortalConfig portalConfig) {
            return new CtripUserService(portalConfig);
        }

        @Bean
        public SsoHeartbeatHandler ctripSsoHeartbeatHandler() {
            return new CtripSsoHeartbeatHandler();
        }
    }
}

