/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.constants.GsonType;
import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.entity.bo.KVEntity;
import com.ctrip.framework.apollo.portal.entity.bo.ReleaseBO;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceGrayDelReleaseModel;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceReleaseModel;
import com.ctrip.framework.apollo.portal.entity.vo.ReleaseCompareResult;
import com.ctrip.framework.apollo.portal.enums.ChangeType;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReleaseService {
    private static final Gson gson = new Gson();
    private final UserInfoHolder userInfoHolder;
    private final AdminServiceAPI.ReleaseAPI releaseAPI;

    public ReleaseService(UserInfoHolder userInfoHolder, AdminServiceAPI.ReleaseAPI releaseAPI) {
        this.userInfoHolder = userInfoHolder;
        this.releaseAPI = releaseAPI;
    }

    public ReleaseDTO publish(NamespaceReleaseModel model) {
        Env env = model.getEnv();
        boolean isEmergencyPublish = model.isEmergencyPublish();
        String appId = model.getAppId();
        String clusterName = model.getClusterName();
        String namespaceName = model.getNamespaceName();
        String releaseBy = StringUtils.isEmpty((String)model.getReleasedBy()) ? this.userInfoHolder.getUser().getUserId() : model.getReleasedBy();
        ReleaseDTO releaseDTO = this.releaseAPI.createRelease(appId, env, clusterName, namespaceName, model.getReleaseTitle(), model.getReleaseComment(), releaseBy, isEmergencyPublish);
        Tracer.logEvent((String)"Namespace.Release", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        return releaseDTO;
    }

    public ReleaseDTO publish(NamespaceGrayDelReleaseModel model, String releaseBy) {
        Env env = model.getEnv();
        boolean isEmergencyPublish = model.isEmergencyPublish();
        String appId = model.getAppId();
        String clusterName = model.getClusterName();
        String namespaceName = model.getNamespaceName();
        ReleaseDTO releaseDTO = this.releaseAPI.createGrayDeletionRelease(appId, env, clusterName, namespaceName, model.getReleaseTitle(), model.getReleaseComment(), releaseBy, isEmergencyPublish, model.getGrayDelKeys());
        Tracer.logEvent((String)"Namespace.Release", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        return releaseDTO;
    }

    public ReleaseDTO updateAndPublish(String appId, Env env, String clusterName, String namespaceName, String releaseTitle, String releaseComment, String branchName, boolean isEmergencyPublish, boolean deleteBranch, ItemChangeSets changeSets) {
        return this.releaseAPI.updateAndPublish(appId, env, clusterName, namespaceName, releaseTitle, releaseComment, branchName, isEmergencyPublish, deleteBranch, changeSets);
    }

    public List<ReleaseBO> findAllReleases(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
        List<ReleaseDTO> releaseDTOs = this.releaseAPI.findAllReleases(appId, env, clusterName, namespaceName, page, size);
        if (CollectionUtils.isEmpty(releaseDTOs)) {
            return Collections.emptyList();
        }
        LinkedList<ReleaseBO> releases = new LinkedList<ReleaseBO>();
        for (ReleaseDTO releaseDTO : releaseDTOs) {
            ReleaseBO release = new ReleaseBO();
            release.setBaseInfo(releaseDTO);
            LinkedHashSet<KVEntity> kvEntities = new LinkedHashSet<KVEntity>();
            Map configurations = (Map)gson.fromJson(releaseDTO.getConfigurations(), GsonType.CONFIG);
            Set entries = configurations.entrySet();
            for (Map.Entry entry : entries) {
                kvEntities.add(new KVEntity((String)entry.getKey(), (String)entry.getValue()));
            }
            release.setItems(kvEntities);
            releaseDTO.setConfigurations("");
            releases.add(release);
        }
        return releases;
    }

    public List<ReleaseDTO> findActiveReleases(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
        return this.releaseAPI.findActiveReleases(appId, env, clusterName, namespaceName, page, size);
    }

    public ReleaseDTO findReleaseById(Env env, long releaseId) {
        HashSet<Long> releaseIds = new HashSet<Long>(1);
        releaseIds.add(releaseId);
        List<ReleaseDTO> releases = this.findReleaseByIds(env, releaseIds);
        if (CollectionUtils.isEmpty(releases)) {
            return null;
        }
        return releases.get(0);
    }

    public List<ReleaseDTO> findReleaseByIds(Env env, Set<Long> releaseIds) {
        return this.releaseAPI.findReleaseByIds(env, releaseIds);
    }

    public ReleaseDTO loadLatestRelease(String appId, Env env, String clusterName, String namespaceName) {
        return this.releaseAPI.loadLatestRelease(appId, env, clusterName, namespaceName);
    }

    public void rollback(Env env, long releaseId, String operator) {
        this.releaseAPI.rollback(env, releaseId, operator);
    }

    public void rollbackTo(Env env, long releaseId, long toReleaseId, String operator) {
        this.releaseAPI.rollbackTo(env, releaseId, toReleaseId, operator);
    }

    public ReleaseCompareResult compare(Env env, long baseReleaseId, long toCompareReleaseId) {
        ReleaseDTO baseRelease = null;
        ReleaseDTO toCompareRelease = null;
        if (baseReleaseId != 0L) {
            baseRelease = this.releaseAPI.loadRelease(env, baseReleaseId);
        }
        if (toCompareReleaseId != 0L) {
            toCompareRelease = this.releaseAPI.loadRelease(env, toCompareReleaseId);
        }
        return this.compare(baseRelease, toCompareRelease);
    }

    public ReleaseCompareResult compare(ReleaseDTO baseRelease, ReleaseDTO toCompareRelease) {
        String key;
        HashMap baseReleaseConfiguration = baseRelease == null ? new HashMap() : (Map)gson.fromJson(baseRelease.getConfigurations(), GsonType.CONFIG);
        HashMap toCompareReleaseConfiguration = toCompareRelease == null ? new HashMap() : (Map)gson.fromJson(toCompareRelease.getConfigurations(), GsonType.CONFIG);
        ReleaseCompareResult compareResult = new ReleaseCompareResult();
        for (Map.Entry entry : baseReleaseConfiguration.entrySet()) {
            key = (String)entry.getKey();
            String firstValue = (String)entry.getValue();
            String secondValue = (String)toCompareReleaseConfiguration.get(key);
            if (secondValue == null) {
                compareResult.addEntityPair(ChangeType.DELETED, new KVEntity(key, firstValue), new KVEntity(key, null));
                continue;
            }
            if (Objects.equal((Object)firstValue, (Object)secondValue)) continue;
            compareResult.addEntityPair(ChangeType.MODIFIED, new KVEntity(key, firstValue), new KVEntity(key, secondValue));
        }
        for (Map.Entry entry : toCompareReleaseConfiguration.entrySet()) {
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (baseReleaseConfiguration.get(key) != null) continue;
            compareResult.addEntityPair(ChangeType.ADDED, new KVEntity(key, ""), new KVEntity(key, value));
        }
        return compareResult;
    }
}

