/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.config.RefreshablePropertySource;
import com.ctrip.framework.apollo.portal.entity.po.ServerConfig;
import com.ctrip.framework.apollo.portal.repository.ServerConfigRepository;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalDBPropertySource
extends RefreshablePropertySource {
    private static final Logger logger = LoggerFactory.getLogger(PortalDBPropertySource.class);
    @Autowired
    private ServerConfigRepository serverConfigRepository;

    public PortalDBPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    public PortalDBPropertySource() {
        super("DBConfig", (Map)Maps.newConcurrentMap());
    }

    protected void refresh() {
        Iterable dbConfigs = this.serverConfigRepository.findAll();
        for (ServerConfig config : dbConfigs) {
            String key = config.getKey();
            String value = config.getValue();
            if (((Map)this.source).isEmpty()) {
                logger.info("Load config from DB : {} = {}", (Object)key, (Object)value);
            } else if (!Objects.equals(((Map)this.source).get(key), value)) {
                logger.info("Load config from DB : {} = {}. Old value = {}", new Object[]{key, value, ((Map)this.source).get(key)});
            }
            ((Map)this.source).put(key, value);
        }
    }
}

